/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.compose.maven.plugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Consumer;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.compose.maven.plugin.CommandBuilder;
import org.honton.chas.compose.maven.plugin.ComposeProjectGoal;
import org.honton.chas.compose.maven.plugin.ExecHelper;

@Mojo(name="down", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST, threadSafe=true)
public class ComposeDown
extends ComposeProjectGoal {
    @Parameter(defaultValue="${project.build.directory}/compose/", required=true, readonly=true)
    File composeProjectDir;

    @Override
    protected String subCommand() {
        return "down";
    }

    @Override
    protected boolean addComposeOptions(CommandBuilder builder) {
        if (!Files.isReadable(this.linkedCompose.toPath())) {
            this.getLog().info((CharSequence)"No linked compose file, `compose down` not executed");
            return false;
        }
        this.queryServiceList();
        builder.addOption("--remove-orphans").addOption("--timeout", Integer.toString(this.timeout));
        return true;
    }

    private void queryServiceList() {
        CommandBuilder builder = this.createBuilder("ps").addGlobalOption("-f", this.linkedCompose.getPath()).addOption("-a").addOption("--format", "{{.Service}}");
        this.saveLogs(new ExecHelper(this.getLog()).outputAsString(this.timeout, builder).split("\\s+"));
    }

    private void saveLogs(String[] services) {
        for (String service : services) {
            CommandBuilder builder = this.createBuilder("logs").addOption("--no-log-prefix").addOption(service);
            Path output = this.composeProjectDir.toPath().resolve(service + ".log");
            try (BufferedWriter writer = Files.newBufferedWriter(output, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                Consumer<CharSequence> consumer = l -> {
                    try {
                        writer.append((CharSequence)l).append('\n');
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                };
                new ExecHelper(this.getLog()).outputToConsumer(this.timeout, consumer, builder);
            }
        }
    }
}

