/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.compose.maven.plugin;

import java.io.IOException;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.compose.maven.plugin.CommandBuilder;
import org.honton.chas.compose.maven.plugin.ComposeGoal;
import org.honton.chas.compose.maven.plugin.ExecHelper;

public abstract class ComposeExecuteGoal
extends ComposeGoal {
    @Parameter(property="compose.cli", defaultValue="docker")
    String cli;
    @Parameter(property="compose.timeout", defaultValue="30")
    public int timeout;

    @Override
    protected void doExecute() throws Exception {
        CommandBuilder builder = this.createBuilder(this.subCommand());
        if (this.addComposeOptions(builder)) {
            this.executeComposeCommand(this.timeout, builder);
            this.postComposeCommand();
        }
    }

    protected CommandBuilder createBuilder(String subCommand) {
        return new CommandBuilder(this.cli, subCommand);
    }

    protected abstract String subCommand();

    private void executeComposeCommand(int secondsToWait, CommandBuilder builder) throws MojoExecutionException {
        int exitCode = new ExecHelper(this.getLog()).waitForExit(secondsToWait, builder);
        if (exitCode != 0) {
            throw new MojoExecutionException("compose exit value: " + exitCode);
        }
    }

    protected boolean addComposeOptions(CommandBuilder builder) throws Exception {
        return true;
    }

    protected void postComposeCommand() throws IOException {
    }

    @Generated
    public String getCli() {
        return this.cli;
    }

    @Generated
    public int getTimeout() {
        return this.timeout;
    }
}

