/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.compose.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

abstract class JarReader
implements AutoCloseable {
    public static final String SERVICES = "Services";
    public static final String DEPENDENCIES = "Dependencies";
    private static final String[] EMPTY = new String[0];
    private final JarFile jarFile;
    private JarEntry jarEntry;

    JarReader(File localFile) throws Exception {
        this.jarFile = new JarFile(localFile);
    }

    void visitEntries() throws Exception {
        Enumeration<JarEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            this.jarEntry = entries.nextElement();
            if (this.jarEntry.isDirectory()) continue;
            this.process();
        }
    }

    String getName() {
        return this.jarEntry.getName();
    }

    InputStream getInputStream() throws IOException {
        return this.jarFile.getInputStream(this.jarEntry);
    }

    @Override
    public void close() throws Exception {
        this.jarFile.close();
    }

    abstract void process() throws Exception;

    boolean isManifestEntry() {
        return this.jarEntry.getName().equals("META-INF/MANIFEST.MF");
    }

    String[] extractMainAttributes(String attributeName) throws IOException {
        try (InputStream is = this.jarFile.getInputStream(this.jarEntry);){
            Manifest manifest = new Manifest(is);
            String value = manifest.getMainAttributes().getValue(attributeName);
            String[] stringArray = value != null ? value.split(",") : EMPTY;
            return stringArray;
        }
    }
}

