/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.compose.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;

class ArtifactHelper {
    private final MavenProject project;
    private final Path composeSrc;
    private final RepositorySystem repoSystem;
    private final RepositorySystemSession repoSession;

    static Optional<Path> findComposePath(Path directory) {
        return Stream.of("compose.yaml", "compose.yml", "compose.json").map(directory::resolve).filter(Files::isReadable).findFirst();
    }

    static DefaultArtifact composeArtifact(String dependency) {
        DefaultArtifact artifact = new DefaultArtifact(dependency);
        if ("".equals(artifact.getClassifier())) {
            artifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "compose", "jar", artifact.getVersion());
        }
        return artifact;
    }

    static String namespacedPath(String namespace, Path path) {
        return namespace + "/" + path.getFileName();
    }

    File fetchArtifact(Artifact artifact) throws ArtifactResolutionException, MojoExecutionException {
        Artifact local = this.repoSystem.resolveArtifact(this.repoSession, new ArtifactRequest(artifact, this.project.getRemoteProjectRepositories(), null)).getArtifact();
        if (local == null) {
            throw new MojoExecutionException(artifact + " is not available");
        }
        return local.getFile();
    }

    void processComposeSrc(final PathConsumer pathConsumer) throws IOException {
        SneakyThrowsConsumer consumer = new SneakyThrowsConsumer(){

            @Override
            public void process(String classifier, String namespace, Path composeYaml) {
                pathConsumer.process(classifier, namespace, composeYaml);
            }
        };
        Optional<Path> composeYaml = ArtifactHelper.findComposePath(this.composeSrc);
        composeYaml.ifPresent(path -> consumer.process("compose", this.project.getArtifactId(), (Path)path));
        try (DirectoryStream<Path> files = Files.newDirectoryStream(this.composeSrc, Files::isReadable);){
            for (Path dir : files) {
                composeYaml = ArtifactHelper.findComposePath(dir);
                composeYaml.ifPresent(path -> {
                    String classifier = dir.getFileName().toString();
                    consumer.process(classifier, classifier, (Path)path);
                });
            }
        }
    }

    String coordinatesFromClassifier(String classifier) {
        return this.project.getGroupId() + ":" + this.project.getArtifactId() + "::" + classifier + ":" + this.project.getVersion();
    }

    public Path jarPath(String classifier) throws IOException {
        return Files.createDirectories(Path.of(this.project.getBuild().getDirectory(), new String[0]), new FileAttribute[0]).resolve(this.project.getArtifactId() + "-" + this.project.getVersion() + "-" + classifier + ".jar");
    }

    @Generated
    public ArtifactHelper(MavenProject project, Path composeSrc, RepositorySystem repoSystem, RepositorySystemSession repoSession) {
        this.project = project;
        this.composeSrc = composeSrc;
        this.repoSystem = repoSystem;
        this.repoSession = repoSession;
    }

    @FunctionalInterface
    static interface PathConsumer {
        public void process(String var1, String var2, Path var3) throws IOException, MojoExecutionException;
    }

    @FunctionalInterface
    static interface SneakyThrowsConsumer {
        public void process(String var1, String var2, Path var3);
    }
}

