/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.compose.maven.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.InterpolatorFilterReader;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.honton.chas.compose.maven.plugin.ArtifactHelper;
import org.honton.chas.compose.maven.plugin.CommandBuilder;
import org.honton.chas.compose.maven.plugin.ComposeProjectGoal;
import org.honton.chas.compose.maven.plugin.InterpolatorFactory;
import org.honton.chas.compose.maven.plugin.JarReader;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

@Mojo(name="link", defaultPhase=LifecyclePhase.TEST, threadSafe=true)
public class ComposeLink
extends ComposeProjectGoal {
    private final Interpolator interpolator;
    private final Yaml yaml;
    private final Map<String, String> extractedPaths = new HashMap<String, String>();
    private final Set<Path> createdDirs = new HashSet<Path>();
    private final Set<String> hostMounts = new HashSet<String>();
    @Parameter
    List<String> dependencies;
    @Parameter
    List<Map<String, String>> variablePorts = new ArrayList<Map<String, String>>();
    @Parameter(defaultValue="true")
    boolean filter;
    @Parameter(property="compose.src", defaultValue="src/compose")
    String composeSrc;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Component
    RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.build.directory}/compose", required=true, readonly=true)
    File composeBuildDirectory;
    private CommandBuilder commandBuilder;
    private Set<String> fetchedDependencies;
    private ArtifactHelper artifactHelper;

    @Inject
    public ComposeLink(MavenSession session, MavenProject project) {
        this.interpolator = InterpolatorFactory.createInterpolator(session, project);
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        this.yaml = new Yaml(options);
    }

    private static BufferedWriter bufferedWriter(Path dstPath) throws IOException {
        return Files.newBufferedWriter(dstPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Override
    public String subCommand() {
        return "config";
    }

    private void addDependency(String dependency) throws MojoExecutionException, IOException, RepositoryException {
        DefaultArtifact artifact = ArtifactHelper.composeArtifact(dependency);
        this.addArtifact(artifact.toString(), this.artifactHelper.fetchArtifact((Artifact)artifact));
    }

    private void addArtifact(final String coordinates, File file) throws IOException, MojoExecutionException, RepositoryException {
        try (JarReader jr = new JarReader(file){

            @Override
            void process() throws IOException, MojoExecutionException, RepositoryException {
                if (this.isManifestEntry()) {
                    ComposeLink.this.extractDependencies(this.extractMainAttributes("Dependencies"));
                } else {
                    ComposeLink.this.processArtifact(coordinates, this.getName(), this.getInputStream());
                }
            }
        };){
            jr.visitEntries();
        }
    }

    void extractDependencies(String[] dependencies) throws MojoExecutionException, IOException, RepositoryException {
        for (String dependency : dependencies) {
            if (!this.fetchedDependencies.add(dependency)) continue;
            this.addDependency(dependency);
        }
    }

    private void processArtifact(String coordinates, String name, InputStream inputStream) throws MojoExecutionException, IOException {
        String priorGav = this.extractedPaths.put(name, coordinates);
        if (priorGav != null && !priorGav.equals(coordinates)) {
            throw new MojoExecutionException(name + " in " + coordinates + " was previously defined in " + priorGav);
        }
        Path dstPath = this.composeBuildDirectory.toPath().resolve(Path.of(name, new String[0]));
        Path parent = dstPath.getParent();
        if (this.createdDirs.add(parent)) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        if (name.endsWith("/compose.yaml")) {
            this.commandBuilder.addGlobalOption("-f", dstPath.toString());
        } else if (name.endsWith("/.env")) {
            this.commandBuilder.addGlobalOption("--env-file", dstPath.toString());
        }
        try (InputStream source = inputStream;){
            this.copyYaml(source, dstPath);
        }
    }

    private void copyYaml(InputStream source, Path dstPath) throws IOException {
        Reader reader = this.interpolateReader(source);
        try (BufferedWriter writer = ComposeLink.bufferedWriter(dstPath);){
            String name = dstPath.getFileName().toString();
            if (name.endsWith(".yaml") || name.endsWith(".yml") || name.endsWith(".json")) {
                Map model = (Map)this.yaml.load(reader);
                this.replaceVariablePorts(model);
                this.yaml.dump((Object)model, (Writer)writer);
            } else {
                reader.transferTo(writer);
            }
        }
    }

    private void replaceVariablePorts(Map<String, Object> model) {
        Object object = model.get("services");
        if (object instanceof Map) {
            Map unTyped;
            Map services = unTyped = (Map)object;
            services.forEach(this::replaceVariablePorts);
            services.forEach(this::collectHostMounts);
        }
    }

    private void replaceVariablePorts(String serviceName, Map<String, Object> serviceDefinition) {
        Object object = serviceDefinition.get("ports");
        if (object instanceof List) {
            List unTyped;
            List ports = unTyped = (List)object;
            List<Object> replacement = ports.stream().map(port -> this.getReplacement(serviceName, port)).toList();
            serviceDefinition.put("ports", replacement);
        }
    }

    private Object getReplacement(String serviceName, Object port) {
        if (port instanceof String) {
            String shortForm = (String)port;
            return this.shortFormReplacement(serviceName, shortForm);
        }
        if (port instanceof Map) {
            Map longForm = (Map)port;
            return this.longFormReplacement(serviceName, longForm);
        }
        return port;
    }

    private String shortFormReplacement(String serviceName, String shortForm) {
        String host;
        String[] parts = shortForm.split(":");
        if (parts.length > 1 && !(host = parts[parts.length - 2]).isEmpty() && !Character.isDigit(host.charAt(0))) {
            String container;
            String replacement = parts[parts.length - 1];
            int slashIdx = replacement.indexOf(47);
            String string = container = slashIdx < 0 ? replacement : replacement.substring(0, slashIdx);
            if (container.indexOf(45) >= 0) {
                throw new IllegalArgumentException("range not supported for variable port");
            }
            this.addVariablePort(serviceName, host, container);
            return replacement;
        }
        return shortForm;
    }

    private Map<?, ?> longFormReplacement(String serviceName, Map<?, ?> longForm) {
        Object container;
        String published;
        Object obj = longForm.get("published");
        if (obj instanceof String && !(published = (String)obj).isEmpty() && !Character.isDigit(published.charAt(0)) && (container = longForm.get("target")) != null) {
            this.addVariablePort(serviceName, published, container.toString());
            longForm.remove("published");
        }
        return longForm;
    }

    private void addVariablePort(String serviceName, String property, String container) {
        this.variablePorts.add(Map.of("service", serviceName, "property", property, "container", container));
    }

    private void collectHostMounts(String serviceName, Map<String, Object> model) {
        Object object = model.get("volumes");
        if (object instanceof List) {
            List volumes = (List)object;
            volumes.forEach(this::collectHostMount);
        }
    }

    private void collectHostMount(Object volume) {
        String shortSyntax;
        int colonIdx;
        if (volume instanceof Map) {
            Object v;
            Map longSyntax = (Map)volume;
            if ("bind".equals(longSyntax.get("type")) && (v = longSyntax.get("source")) instanceof String) {
                String source = (String)v;
                this.collectVolume(source);
            }
        } else if (volume instanceof String && (colonIdx = (shortSyntax = (String)volume).indexOf(58)) >= 0) {
            this.collectVolume(shortSyntax.substring(0, colonIdx));
        }
    }

    private void collectVolume(String volume) {
        char isPath;
        if (!(volume.isEmpty() || (isPath = volume.charAt(0)) != '/' && isPath != '.')) {
            this.hostMounts.add(volume);
        }
    }

    private Reader interpolateReader(InputStream inputStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        return this.filter ? new InterpolatorFilterReader((Reader)reader, this.interpolator) : reader;
    }

    @Override
    protected boolean addComposeOptions(CommandBuilder builder) throws Exception {
        this.commandBuilder = builder;
        Path composeSrcPath = Path.of(this.composeSrc, new String[0]);
        this.artifactHelper = new ArtifactHelper(this.project, composeSrcPath, this.repoSystem, this.repoSession);
        this.fetchedDependencies = new HashSet<String>();
        if (this.dependencies != null) {
            for (String dependency : this.dependencies) {
                this.addDependency(dependency);
            }
        }
        if (Files.isDirectory(composeSrcPath, new LinkOption[0])) {
            this.artifactHelper.processComposeSrc(this::processLocalArtifact);
        }
        builder.addGlobalOption("--project-directory", this.composeBuildDirectory.getAbsolutePath()).addOption("--no-interpolate").addOption("-o", this.composeFile().toString());
        if (!builder.getGlobalOptions().contains("-f")) {
            this.getLog().info((CharSequence)"No artifacts to link, `compose config` not executed");
            return false;
        }
        return true;
    }

    private void processLocalArtifact(String classifier, String namespace, Path composeYaml) throws IOException, MojoExecutionException {
        String coordinates = this.artifactHelper.coordinatesFromClassifier(classifier);
        String namespacedPath = ArtifactHelper.namespacedPath(namespace, composeYaml);
        this.processArtifact(coordinates, namespacedPath, Files.newInputStream(composeYaml, new OpenOption[0]));
    }

    @Override
    protected void postComposeCommand(int exitCode) throws IOException, MojoExecutionException {
        super.postComposeCommand(exitCode);
        Path mountsFile = this.mountsFile();
        if (this.hostMounts.isEmpty()) {
            Files.deleteIfExists(mountsFile);
        } else {
            try (BufferedWriter bw = ComposeLink.bufferedWriter(mountsFile);){
                this.yaml.dump((Object)this.hostMounts.toArray(), (Writer)bw);
            }
        }
        Path portsFile = this.portsFile();
        if (this.variablePorts.isEmpty()) {
            Files.deleteIfExists(portsFile);
        } else {
            try (BufferedWriter bw = ComposeLink.bufferedWriter(portsFile);){
                this.yaml.dump(this.variablePorts, (Writer)bw);
            }
        }
    }
}

