/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.compose.maven.plugin;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.compose.maven.plugin.CommandBuilder;
import org.honton.chas.compose.maven.plugin.ComposeExecuteGoal;
import org.honton.chas.compose.maven.plugin.ExecHelper;

public abstract class ComposeProjectGoal
extends ComposeExecuteGoal {
    @Parameter(defaultValue="${project.artifactId}", required=true)
    String projectName;
    @Parameter(defaultValue="${project.build.directory}/compose/", required=true, readonly=true)
    String composeProjectDir;
    Path composeProject;

    @Override
    protected CommandBuilder createBuilder(String subCommand) {
        this.composeProject = Path.of("", new String[0]).toAbsolutePath().relativize(Path.of(this.composeProjectDir, new String[0]));
        return super.createBuilder(subCommand).addGlobalOption("--project-name", this.projectName);
    }

    protected Path composeFile() {
        return this.composeProject.resolve("compose.yaml");
    }

    protected Path portsFile() {
        return this.composeProject.resolve("ports.yaml");
    }

    protected Path mountsFile() {
        return this.composeProject.resolve("mounts.yaml");
    }

    protected void saveServiceLogs() {
        CommandBuilder builder = this.createBuilder("ps").addGlobalOption("-f", this.composeFile().toString()).addOption("-a").addOption("--format", "{{.Service}}");
        this.saveLogs(new ExecHelper(this.getLog()).outputAsString(this.timeout, builder).split("\\s+"));
    }

    private void saveLogs(String[] services) {
        for (String service : services) {
            CommandBuilder builder = this.createBuilder("logs").addOption("--no-log-prefix").addOption(service);
            Path output = this.composeProject.resolve(service + ".log");
            try (BufferedWriter writer = Files.newBufferedWriter(output, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                Consumer<CharSequence> consumer = l -> {
                    try {
                        writer.append((CharSequence)l).append('\n');
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                };
                new ExecHelper(this.getLog()).outputToConsumer(this.timeout, consumer, builder);
            }
        }
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public String getComposeProjectDir() {
        return this.composeProjectDir;
    }

    @Generated
    public Path getComposeProject() {
        return this.composeProject;
    }
}

