/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.compose.maven.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.InterpolatorFilterReader;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.honton.chas.compose.maven.plugin.ArtifactHelper;
import org.honton.chas.compose.maven.plugin.CommandBuilder;
import org.honton.chas.compose.maven.plugin.ComposeProjectGoal;
import org.honton.chas.compose.maven.plugin.InterpolatorFactory;
import org.honton.chas.compose.maven.plugin.JarReader;
import org.honton.chas.compose.maven.plugin.PortInfo;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

@Mojo(name="link", defaultPhase=LifecyclePhase.TEST, threadSafe=true)
public class ComposeLink
extends ComposeProjectGoal {
    public static final String HOST_IP = "host_ip";
    private static final String PUBLISHED = "published";
    private static final String TARGET = "target";
    private final Interpolator interpolator;
    private final Yaml yaml;
    private final Set<String> artifactCoordinates = new HashSet<String>();
    private final Set<String> dependencyCoordinates = new HashSet<String>();
    private final Set<Path> createdDirs = new HashSet<Path>();
    private final Set<String> hostMounts = new HashSet<String>();
    private final Map<String, PortInfo> variablePorts = new HashMap<String, PortInfo>();
    @Parameter
    List<String> dependencies;
    @Parameter(property="compose.filter", defaultValue="true")
    boolean filter;
    @Parameter(property="compose.source", defaultValue="${project.basedir}/src/main/compose")
    String source;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject mavenProject;
    @Component
    RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    private CommandBuilder commandBuilder;
    private ArtifactHelper artifactHelper;

    @Inject
    public ComposeLink(MavenSession session, MavenProject project) {
        this.interpolator = InterpolatorFactory.createInterpolator(session, project);
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        this.yaml = new Yaml(options);
    }

    private static BufferedWriter bufferedWriter(Path dstPath) throws IOException {
        return Files.newBufferedWriter(dstPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static boolean isIpV6(String hostIp) {
        return hostIp.indexOf(58) >= 0;
    }

    @Override
    public String subCommand() {
        return "config";
    }

    private void addDependency(String dependency) {
        DefaultArtifact artifact = ArtifactHelper.composeArtifact(dependency);
        String gav = artifact.toString();
        if (this.dependencyCoordinates.add(gav)) {
            this.getLog().debug((CharSequence)("adding dependency " + gav));
            this.addArtifact(gav, this.artifactHelper.fetchArtifact((Artifact)artifact));
        }
    }

    private void addArtifact(final String coordinates, File file) throws IOException, MojoExecutionException, RepositoryException {
        try (JarReader jr = new JarReader(file){

            @Override
            void process() throws IOException, MojoExecutionException, RepositoryException {
                if (this.isManifestEntry()) {
                    ComposeLink.this.extractDependencies(this.extractMainAttributes("Dependencies"));
                } else {
                    ComposeLink.this.processArtifact(coordinates, this.getName(), this.getInputStream());
                }
            }
        };){
            jr.visitEntries();
        }
    }

    void extractDependencies(String[] dependencies) throws MojoExecutionException, IOException, RepositoryException {
        for (String dependency : dependencies) {
            this.addDependency(dependency);
        }
    }

    private void processArtifact(String coordinates, String name, InputStream inputStream) throws IOException {
        if (!this.artifactCoordinates.add(coordinates)) {
            return;
        }
        this.getLog().debug((CharSequence)("processing artifact: " + coordinates));
        Path dstPath = this.composeProject.resolve(name);
        Path parent = dstPath.getParent();
        if (this.createdDirs.add(parent)) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        if (name.endsWith("/compose.yaml")) {
            this.commandBuilder.addGlobalOption("-f", dstPath.toString());
        } else if (name.endsWith("/.env")) {
            this.commandBuilder.addGlobalOption("--env-file", dstPath.toString());
        }
        try (InputStream source = inputStream;){
            this.copyYaml(source, dstPath);
        }
    }

    private void copyYaml(InputStream source, Path dstPath) throws IOException {
        Reader reader = this.interpolateReader(source);
        try (BufferedWriter writer = ComposeLink.bufferedWriter(dstPath);){
            String name = dstPath.getFileName().toString();
            if (name.endsWith(".yaml") || name.endsWith(".yml") || name.endsWith(".json")) {
                Map model = (Map)this.yaml.load(reader);
                this.replaceVariablePorts(model);
                this.yaml.dump((Object)model, (Writer)writer);
            } else {
                reader.transferTo(writer);
            }
        }
    }

    private void replaceVariablePorts(Map<String, Object> model) {
        Object object = model.get("services");
        if (object instanceof Map) {
            Map unTyped;
            Map services = unTyped = (Map)object;
            services.forEach(this::replaceVariablePorts);
            services.forEach(this::collectHostMounts);
        }
    }

    private void replaceVariablePorts(String serviceName, Map<String, Object> serviceDefinition) {
        Object object = serviceDefinition.get("ports");
        if (object instanceof List) {
            List unTyped = (List)object;
            List<Object> replacement = unTyped.stream().map(port -> this.getReplacement(serviceName, port)).toList();
            serviceDefinition.put("ports", replacement);
        }
    }

    private Object getReplacement(String serviceName, Object port) {
        if (port instanceof String) {
            String shortForm = (String)port;
            return this.shortFormReplacement(serviceName, shortForm);
        }
        if (port instanceof Map) {
            Map longForm = (Map)port;
            return this.longFormReplacement(serviceName, longForm);
        }
        return port;
    }

    private Object shortFormReplacement(String serviceName, String shortForm) throws MojoExecutionException {
        String target;
        String property;
        int hostContainerIdx = shortForm.lastIndexOf(58);
        if (hostContainerIdx < 0) {
            return shortForm;
        }
        HashMap<String, Object> longForm = new HashMap<String, Object>();
        String host = shortForm.substring(0, hostContainerIdx);
        int ipHostIdx = host.lastIndexOf(58);
        if (ipHostIdx < 0) {
            property = host;
            longForm.put(HOST_IP, "0.0.0.0");
        } else {
            property = host.substring(ipHostIdx + 1);
            String hostIp = host.substring(0, ipHostIdx);
            if (ComposeLink.isIpV6(hostIp)) {
                throw new MojoExecutionException("port variables not supported for IPv6");
            }
            longForm.put(HOST_IP, hostIp);
        }
        if (property.isEmpty() || Character.isDigit(property.charAt(0))) {
            return shortForm;
        }
        String container = shortForm.substring(hostContainerIdx + 1);
        int containerProtocolIdx = container.lastIndexOf(47);
        if (containerProtocolIdx < 0) {
            target = container;
        } else {
            target = container.substring(0, containerProtocolIdx);
            longForm.put("protocol", container.substring(containerProtocolIdx + 1));
        }
        longForm.put(TARGET, Integer.valueOf(target));
        if (container.indexOf(45) >= 0) {
            throw new MojoExecutionException("range not supported for variable port");
        }
        String env = this.addVariablePort(serviceName, property, container);
        if (env != null) {
            longForm.put(PUBLISHED, env);
        }
        return longForm;
    }

    private Map<String, Object> longFormReplacement(String serviceName, Map<String, Object> longForm) throws MojoExecutionException {
        Object object = longForm.get(TARGET);
        if (object instanceof Integer) {
            String property;
            Integer target = (Integer)object;
            Object object2 = longForm.get(PUBLISHED);
            if (object2 instanceof String && !(property = (String)object2).isEmpty() && !Character.isDigit(property.charAt(0))) {
                String hostIp;
                Object object3 = longForm.get(HOST_IP);
                if (object3 instanceof String && ComposeLink.isIpV6(hostIp = (String)object3)) {
                    throw new MojoExecutionException("port variables not supported for IPv6");
                }
                String env = this.addVariablePort(serviceName, property, target.toString());
                if (env == null) {
                    longForm.remove(PUBLISHED);
                } else {
                    longForm.put(PUBLISHED, env);
                }
            }
        } else {
            throw new MojoExecutionException("missing port target for service " + serviceName);
        }
        return longForm;
    }

    private String addVariablePort(String serviceName, String property, String container) throws MojoExecutionException {
        String env;
        String key;
        PortInfo variablePort = new PortInfo().setService(serviceName).setContainer(container);
        if (property.startsWith("${") && property.endsWith("}")) {
            key = property.substring(2, property.length() - 1);
            env = key.toUpperCase(Locale.ROOT).replace('.', '_');
            variablePort.setEnv(env);
        } else {
            key = property;
            env = null;
        }
        variablePort.setProperty(key);
        PortInfo prior = this.variablePorts.put(key, variablePort);
        if (prior != null) {
            throw new MojoExecutionException("property " + key + " for service " + variablePort.getService() + " was previously defined in " + prior.getService());
        }
        return env != null ? "${" + env + "}" : null;
    }

    private void collectHostMounts(String serviceName, Map<String, Object> model) {
        Object object = model.get("volumes");
        if (object instanceof List) {
            List volumes = (List)object;
            volumes.forEach(this::collectHostMount);
        }
    }

    private void collectHostMount(Object volume) {
        String shortSyntax;
        int colonIdx;
        if (volume instanceof Map) {
            Object v;
            Map longSyntax = (Map)volume;
            if ("bind".equals(longSyntax.get("type")) && (v = longSyntax.get("source")) instanceof String) {
                String source = (String)v;
                this.collectVolume(source);
            }
        } else if (volume instanceof String && (colonIdx = (shortSyntax = (String)volume).indexOf(58)) >= 0) {
            this.collectVolume(shortSyntax.substring(0, colonIdx));
        }
    }

    private void collectVolume(String volume) {
        char isPath;
        if (!(volume.isEmpty() || (isPath = volume.charAt(0)) != '/' && isPath != '.')) {
            this.hostMounts.add(volume);
        }
    }

    private Reader interpolateReader(InputStream inputStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        return this.filter ? new InterpolatorFilterReader((Reader)reader, this.interpolator) : reader;
    }

    @Override
    protected boolean addComposeOptions(CommandBuilder builder) throws Exception {
        this.commandBuilder = builder;
        Path composeSrcPath = Path.of(this.source, new String[0]);
        this.artifactHelper = new ArtifactHelper(this.mavenProject, composeSrcPath, this.repoSystem, this.repoSession);
        ArtifactHelper.toStream(this.dependencies).forEach(this::addDependency);
        if (Files.isDirectory(composeSrcPath, new LinkOption[0])) {
            this.artifactHelper.processComposeSrc(this.getLog(), this::processLocalArtifact);
        }
        builder.addGlobalOption("--project-directory", this.composeProject.toString()).addOption("--no-interpolate").addOption("-o", this.composeProject.resolve("compose.yaml").toString());
        if (!builder.getGlobalOptions().contains("-f")) {
            this.getLog().info((CharSequence)"No artifacts to link, `compose config` not executed");
            return false;
        }
        return true;
    }

    private void processLocalArtifact(String classifier, String namespace, Path composeYaml) throws IOException {
        String coordinates = this.artifactHelper.coordinatesFromClassifier(classifier);
        String namespacedPath = ArtifactHelper.namespacedPath(namespace, composeYaml);
        this.processArtifact(coordinates, namespacedPath, Files.newInputStream(composeYaml, new OpenOption[0]));
    }

    @Override
    protected void postComposeCommand(String exitMessage) throws IOException, MojoExecutionException {
        super.postComposeCommand(exitMessage);
        Path mountsFile = this.composeProject.resolve("mounts.yaml");
        if (this.hostMounts.isEmpty()) {
            Files.deleteIfExists(mountsFile);
        } else {
            try (BufferedWriter bw = ComposeLink.bufferedWriter(mountsFile);){
                this.yaml.dump((Object)this.hostMounts.toArray(), (Writer)bw);
            }
        }
        Path portsFile = this.composeProject.resolve("ports.yaml");
        if (this.variablePorts.isEmpty()) {
            Files.deleteIfExists(portsFile);
        } else {
            try (BufferedWriter bw = ComposeLink.bufferedWriter(portsFile);){
                this.yaml.dump(this.variablePorts.values().stream().map(PortInfo::toMap).toList(), (Writer)bw);
            }
        }
    }
}

