/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.compose.maven.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.honton.chas.compose.maven.plugin.CommandBuilder;
import org.honton.chas.compose.maven.plugin.ComposeLogsGoal;
import org.honton.chas.compose.maven.plugin.ExecHelper;
import org.honton.chas.compose.maven.plugin.InterpolatorFactory;
import org.honton.chas.compose.maven.plugin.PortInfo;
import org.yaml.snakeyaml.Yaml;

@Mojo(name="up", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, threadSafe=true)
public class ComposeUp
extends ComposeLogsGoal {
    private final Interpolator interpolator;
    @Parameter
    Map<String, String> env = new HashMap<String, String>();
    @Parameter
    Map<String, String> alias;
    @Parameter(defaultValue="${session.userProperties}", required=true, readonly=true)
    Properties userProperties;
    private Yaml yaml;
    private List<PortInfo> portInfos;

    @Inject
    public ComposeUp(MavenSession session, MavenProject project) {
        this.interpolator = InterpolatorFactory.createInterpolator(session, project);
    }

    @Override
    protected String subCommand() {
        return "up";
    }

    @Override
    protected boolean addComposeOptions(CommandBuilder builder) {
        Path composeFile = this.composeProject.resolve("compose.yaml");
        if (!Files.isReadable(composeFile)) {
            this.getLog().info((CharSequence)"No linked compose file, `compose up` not executed");
            return false;
        }
        this.yaml = new Yaml();
        this.createHostSourceDirs();
        Path portsFile = this.composeProject.resolve("ports.yaml");
        this.portInfos = Files.isReadable(portsFile) ? this.readPorts(portsFile) : List.of();
        this.allocatePorts();
        if (this.env != null && !this.env.isEmpty()) {
            builder.addGlobalOption("--env-file", this.createEnvFile());
        }
        builder.addGlobalOption("-f", composeFile.toString()).addOption("--renew-anon-volumes").addOption("--remove-orphans").addOption("--pull", "missing").addOption("--quiet-pull").addOption("--wait").addOption("--wait-timeout", Integer.toString(this.timeout));
        return true;
    }

    private void allocatePorts() throws IOException {
        for (PortInfo portInfo : this.portInfos) {
            String envVar = portInfo.getEnv();
            if (envVar == null) continue;
            String key = portInfo.getProperty();
            String value = this.userProperties.getProperty(key);
            if (value == null) {
                try (ServerSocket serverSocket = new ServerSocket(0);){
                    value = Integer.toString(serverSocket.getLocalPort());
                    this.getLog().info((CharSequence)("Allocated port: " + value + " for environment variable: " + envVar));
                }
                this.userProperties.setProperty(key, value);
            }
            this.env.put(envVar, value);
        }
    }

    private String createEnvFile() throws IOException {
        Path envFile = this.composeProject.resolve(".env");
        try (BufferedWriter writer = Files.newBufferedWriter(envFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            this.env.forEach((k, v) -> {
                try {
                    writer.append((CharSequence)k).append('=').append((CharSequence)v).append(System.lineSeparator());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        return envFile.toString();
    }

    private void createHostSourceDirs() throws IOException {
        Path mountsFile = this.composeProject.resolve("mounts.yaml");
        if (Files.isReadable(mountsFile)) {
            this.readMounts(mountsFile).forEach(this::createSourceDirectory);
        }
    }

    private void createSourceDirectory(String location) {
        Path path = Path.of(location, new String[0]);
        if (!path.isAbsolute()) {
            path = this.composeProject.resolve(location).normalize();
        }
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to create directory " + path), (Throwable)e);
            }
        }
    }

    private List<String> readMounts(Path mountsPath) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(mountsPath);){
            List list = (List)this.yaml.load((Reader)reader);
            return list;
        }
    }

    @Override
    protected void postComposeCommand(String exitMessage) throws MojoExecutionException, IOException {
        if (exitMessage != null) {
            this.saveServiceLogs(this.composeProject.resolve("compose.yaml"));
            throw new MojoExecutionException(exitMessage);
        }
        this.portInfos.forEach(this::assignMavenVariable);
        if (this.alias != null) {
            try {
                this.interpolateAliases();
            }
            catch (InterpolationException e) {
                throw new MojoExecutionException((Throwable)e);
            }
        }
    }

    private List<PortInfo> readPorts(Path portsPath) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(portsPath);){
            List<PortInfo> list = ((List)this.yaml.load((Reader)reader)).stream().map(PortInfo::fromMap).toList();
            return list;
        }
    }

    private void assignMavenVariable(PortInfo portInfo) {
        CommandBuilder builder = this.createBuilder("port");
        builder.addOption(portInfo.getService(), portInfo.getContainer());
        String port = new ExecHelper(this.getLog()).outputAsString(this.timeout, builder).strip();
        port = port.substring(port.lastIndexOf(58) + 1);
        this.getLog().info((CharSequence)("Setting " + portInfo.getProperty() + " to " + port));
        this.userProperties.put(portInfo.getProperty(), port);
    }

    private void interpolateAliases() throws InterpolationException {
        for (Map.Entry<String, String> aliasEntry : this.alias.entrySet()) {
            String name = aliasEntry.getKey();
            String target = this.interpolator.interpolate(aliasEntry.getValue());
            String value = this.userProperties.getProperty(target);
            if (value != null) {
                this.getLog().info((CharSequence)("Alias " + name + " to " + target + " (" + value + ")"));
                this.userProperties.put(name, value);
                continue;
            }
            this.getLog().warn((CharSequence)("Alias " + name + "(" + target + ") does not have value"));
        }
    }
}

