/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.honton.chas.configuration.ConfigurationCache;
import org.honton.chas.configuration.ConfigurationSource;
import org.honton.chas.configuration.DataFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ConfigurationCacheFactory {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationCacheFactory.class);
    private final ConcurrentMap<Key, ConfigurationCache<?>> caches = new ConcurrentHashMap();
    static final String CLASSPATH_SCHEMA = "classpath:";
    private static final int CLASSPATH_SCHEMA_OFFSET = "classpath:".length();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Produces
    @ConfigurationSource(value="")
    <T> ConfigurationCache<T> getCache(InjectionPoint injectionPoint) {
        Key key = new Key(injectionPoint);
        ConfigurationCache cache = (ConfigurationCache)this.caches.get(key);
        if (cache == null) {
            ConcurrentMap<Key, ConfigurationCache<?>> concurrentMap = this.caches;
            synchronized (concurrentMap) {
                cache = new CacheCreator(key, injectionPoint).createCache();
                this.caches.put(key, cache);
            }
        }
        return cache;
    }

    private static ConfigurationSource getConfigurationSource(InjectionPoint injectionPoint) {
        return (ConfigurationSource)injectionPoint.getAnnotated().getAnnotation(ConfigurationSource.class);
    }

    private static class CacheCreator {
        private final Key key;
        private final InjectionPoint injectionPoint;
        private URL matchUrl;
        private ObjectMapper objectMapper;

        private CacheCreator(Key key, InjectionPoint injectionPoint) {
            this.key = key;
            this.injectionPoint = injectionPoint;
        }

        private Class<?> getDeclaringClass() {
            Member member = this.injectionPoint.getMember();
            return member.getDeclaringClass();
        }

        private URL getMatchUrl(String source) throws IOException {
            if (source.startsWith(ConfigurationCacheFactory.CLASSPATH_SCHEMA)) {
                if (source.length() == CLASSPATH_SCHEMA_OFFSET) {
                    throw new IllegalArgumentException("classpath uri must include resource name");
                }
                return this.getMatchUrlFromResource(source.substring(CLASSPATH_SCHEMA_OFFSET));
            }
            return new URL(source);
        }

        private URL getMatchUrlFromResource(String resource) throws IOException {
            Class<?> declaringClass = this.getDeclaringClass();
            resource = resource.charAt(0) == '/' ? resource.substring(1) : declaringClass.getPackage().getName().replace('.', '/') + '/' + resource;
            URL matchUrl = null;
            Enumeration<URL> urls = declaringClass.getClassLoader().getResources(resource);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (matchUrl == null) {
                    matchUrl = url;
                    continue;
                }
                log.warn("multiple matches in classpath, ignoring " + url);
            }
            if (matchUrl == null) {
                throw new IOException("resource '" + resource + " not found in classpath");
            }
            return matchUrl;
        }

        private void setObjectMapperAndUrl(String path) {
            int solidus = path.lastIndexOf(47) + 1;
            int period = path.lastIndexOf(46) + 1;
            if (solidus >= period) {
                throw new IllegalArgumentException("extension required to determine data format");
            }
            DataFormat df = DataFormat.of(path.substring(period));
            this.objectMapper = df.getObjectMapper();
            if (this.objectMapper == null) {
                throw new UnsupportedOperationException((Object)((Object)df) + " does not have dependencies in classpath");
            }
            this.matchUrl = this.getMatchUrl(path);
        }

        private <T> ConfigurationCache<T> createCache() {
            this.setObjectMapperAndUrl(this.key.getSource());
            return new ConfigurationCache(this.key.getType(), this.objectMapper, this.matchUrl, ConfigurationCacheFactory.getConfigurationSource(this.injectionPoint).interval());
        }
    }

    private static class Key {
        private final String source;
        private final Type type;

        Key(InjectionPoint injectionPoint) {
            this.source = ConfigurationCacheFactory.getConfigurationSource(injectionPoint).value();
            this.type = ((ParameterizedType)injectionPoint.getType()).getActualTypeArguments()[0];
        }

        public String getSource() {
            return this.source;
        }

        public Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            Type this$type = this.getType();
            Type other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Key;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }
}

