/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.configuration;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ConfigurationCache<T> {
    private final JavaType type;
    private final ObjectMapper objectMapper;
    private final URL sourceUrl;
    private final File file;
    private final long checkInterval;
    private final Lock lock;
    private T bean;
    private long lastCheckTime;
    private long lastFileTime;

    ConfigurationCache(Type type, ObjectMapper objectMapper, URL sourceUrl, long checkInterval) {
        this.type = objectMapper.getTypeFactory().constructType(type);
        this.objectMapper = objectMapper;
        this.sourceUrl = sourceUrl;
        this.file = ConfigurationCache.getFile(sourceUrl);
        this.checkInterval = checkInterval;
        this.lock = new ReentrantLock();
        this.get();
    }

    public T get() {
        if (this.shouldRefresh()) {
            this.bean = this.objectMapper.readValue(this.sourceUrl, this.type);
        }
        return this.bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldRefresh() {
        this.lock.lock();
        try {
            long currentTime = System.currentTimeMillis();
            boolean notExpired = currentTime - this.lastCheckTime < this.checkInterval;
            this.lastCheckTime = currentTime;
            if (notExpired) {
                boolean bl = false;
                return bl;
            }
            if (this.file == null) {
                boolean bl = true;
                return bl;
            }
            long currentFileTime = this.file.lastModified();
            boolean isOld = this.lastFileTime < currentFileTime;
            this.lastFileTime = currentFileTime;
            boolean bl = isOld;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static File getFile(URL sourceUrl) {
        String scheme = sourceUrl.getProtocol();
        if ("jar".equals(scheme)) {
            int colon;
            String fileName = sourceUrl.getFile();
            scheme = fileName.substring(0, colon = fileName.indexOf(58));
            if ("file".equals(scheme)) {
                int bang = fileName.indexOf(33);
                return new File(fileName.substring(colon + 1, bang));
            }
        } else if ("file".equals(scheme)) {
            return new File(sourceUrl.toURI());
        }
        return null;
    }

    JavaType getType() {
        return this.type;
    }

    ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    URL getSourceUrl() {
        return this.sourceUrl;
    }

    File getFile() {
        return this.file;
    }

    long getCheckInterval() {
        return this.checkInterval;
    }

    Lock getLock() {
        return this.lock;
    }

    T getBean() {
        return this.bean;
    }

    long getLastCheckTime() {
        return this.lastCheckTime;
    }

    long getLastFileTime() {
        return this.lastFileTime;
    }
}

