/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.honton.chas.objectmanager.factory.ConfObjectManagerFactory;
import org.honton.chas.objectmanager.factory.JsonObjectManagerFactory;
import org.honton.chas.objectmanager.factory.ObjectMapperFactory;
import org.honton.chas.objectmanager.factory.XmlObjectManagerFactory;
import org.honton.chas.objectmanager.factory.YamlObjectManagerFactory;

public enum DataFormat {
    JSON(JsonObjectManagerFactory.class),
    CONF(ConfObjectManagerFactory.class),
    YAML(YamlObjectManagerFactory.class),
    XML(XmlObjectManagerFactory.class);

    private final String extension = this.name().toLowerCase();
    private final ObjectMapper objectMapper;

    private DataFormat(Class<? extends ObjectMapperFactory> factory) {
        this.objectMapper = ObjectMapperFactory.createMapper(this.name(), factory);
    }

    public static DataFormat of(String extension) {
        for (DataFormat dataFormat : DataFormat.values()) {
            if (!dataFormat.extension.equals(extension)) continue;
            return dataFormat;
        }
        throw new IllegalArgumentException("extension '" + extension + "' not supported");
    }

    public String getExtension() {
        return this.extension;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

