/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.datadog.apm.cdi;

import java.util.concurrent.Callable;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.honton.chas.datadog.apm.SpanBuilder;
import org.honton.chas.datadog.apm.TraceConfiguration;
import org.honton.chas.datadog.apm.Tracer;
import org.honton.chas.datadog.apm.api.Span;
import org.honton.chas.datadog.apm.sender.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class TracerImpl
implements Tracer {
    private static final Logger log = LoggerFactory.getLogger(TracerImpl.class);
    private final ThreadLocal<SpanBuilder> currentSpan = new ThreadLocal();
    @Inject
    private Writer writer;
    private String service;

    @Inject
    void setTraceConfiguration(TraceConfiguration configuration) {
        this.service = configuration.getService();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T executeCallable(String resource, String operation, Callable<T> callable) {
        SpanBuilder builder = this.createSpan(resource, operation);
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            builder.exception(e);
            throw e;
        }
        finally {
            this.closeSpan(builder);
        }
    }

    @Override
    public void executeRunnable(String resource, String operation, Runnable runnable) {
        SpanBuilder builder = this.createSpan(resource, operation);
        try {
            runnable.run();
        }
        catch (Exception e) {
            builder.exception(e);
            throw e;
        }
        finally {
            this.closeSpan(builder);
        }
    }

    @Override
    public SpanBuilder getCurrentSpan() {
        return this.currentSpan.get();
    }

    @Override
    public SpanBuilder importSpan(Tracer.HeaderAccessor headerAccessor) {
        SpanBuilder current;
        String traceIdHeader = headerAccessor.getValue("x-ddtrace-parent_trace_id");
        if (traceIdHeader == null) {
            current = SpanBuilder.createRoot();
        } else {
            long traceId = Long.parseLong(traceIdHeader, 16);
            long spanId = Long.parseLong(headerAccessor.getValue("x-ddtrace-parent_span_id"), 16);
            current = SpanBuilder.createChild(traceId, spanId);
        }
        this.currentSpan.set(current);
        return current;
    }

    @Override
    public void exportSpan(String resource, String operation, Tracer.HeaderMutator headerAccessor) {
        SpanBuilder span = this.createSpan(resource, operation).type("http");
        headerAccessor.setValue("x-ddtrace-parent_trace_id", Long.toHexString(span.traceId()));
        headerAccessor.setValue("x-ddtrace-parent_span_id", Long.toHexString(span.spanId()));
    }

    @Override
    public SpanBuilder createSpan() {
        SpanBuilder parent = this.currentSpan.get();
        SpanBuilder span = parent == null ? SpanBuilder.createRoot() : parent.createChild();
        this.currentSpan.set(span);
        return span;
    }

    @Override
    public void closeCurrentSpan() {
        this.closeSpan(this.currentSpan.get());
    }

    @Override
    public void closeSpan(SpanBuilder current) {
        try {
            this.currentSpan.set(current.parent());
            Span span = current.finishSpan(this.service);
            this.queueSpan(span);
        }
        catch (RuntimeException re) {
            log.error("Exception in tracing", (Throwable)re);
        }
    }

    void queueSpan(Span span) {
        this.writer.queue(span);
    }

    private SpanBuilder createSpan(String resource, String operation) {
        return this.createSpan().resource(resource).operation(operation);
    }
}

