/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.datadog.apm.sender;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import org.honton.chas.datadog.apm.TraceConfiguration;
import org.honton.chas.datadog.apm.api.ApmApi;
import org.honton.chas.datadog.apm.api.ApmApi0_2;
import org.honton.chas.datadog.apm.api.ApmApi0_3;
import org.honton.chas.datadog.apm.api.Span;
import org.honton.chas.datadog.apm.api.Trace;
import org.honton.chas.datadog.apm.jackson.MsgPackProvider;
import org.honton.chas.datadog.apm.sender.TraceQueue;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Writer {
    private static final Logger log = LoggerFactory.getLogger(Writer.class);
    private volatile TraceQueue queue;
    private Thread worker;
    private ApmApi apmApi;
    long backoffExpiration;
    private long backoffDuration;
    private String apmUri;

    @Inject
    void setTraceConfiguration(TraceConfiguration configuration) {
        this.backoffDuration = configuration.getBackoffDuration();
        this.apmUri = configuration.getCollectorUrl();
    }

    @PostConstruct
    void initialize() {
        this.initializeWith0_3();
        this.queue = new TraceQueue();
        this.startWorker();
    }

    public void queue(Span span) {
        TraceQueue q = this.queue;
        if (q != null) {
            q.supply(new Trace(span));
        }
    }

    void stop() {
        this.worker.interrupt();
    }

    boolean isStopped() {
        return this.queue == null;
    }

    List<Trace> consumeAndSend() {
        try {
            return this.queue.consume();
        }
        catch (InterruptedException ie) {
            this.queue = null;
            return null;
        }
    }

    private void trySend(List<Trace> list) {
        if (System.currentTimeMillis() > this.backoffExpiration) {
            try {
                this.send(list);
            }
            catch (RuntimeException re) {
                log.info("writer worker problem", (Throwable)re);
                this.backoffExpiration = System.currentTimeMillis() + this.backoffDuration;
            }
        }
    }

    private void send(List<Trace> traces) {
        block2: {
            try {
                this.apmApi.reportTraces(traces);
            }
            catch (NotFoundException | NotSupportedException cee) {
                if (!(this.apmApi instanceof ApmApi0_3)) break block2;
                this.fallbackTo0_2();
                this.send(traces);
            }
        }
    }

    private void fallbackTo0_2() {
        this.apmApi = this.getProxy(ApmApi0_2.class, new Object[0]);
    }

    private void initializeWith0_3() {
        this.apmApi = this.getProxy(ApmApi0_3.class, new Object[]{new MsgPackProvider()});
    }

    private void startWorker() {
        this.worker = new Thread("APM writer"){
            {
                this.setDaemon(true);
            }

            @Override
            public void run() {
                while (true) {
                    List<Trace> traces;
                    if ((traces = Writer.this.consumeAndSend()) == null) break;
                    Writer.this.trySend(traces);
                }
                log.error("writer worker shutdown");
            }
        };
        this.worker.start();
    }

    private <T> T getProxy(Class<T> proxyType, Object ... providers) {
        ResteasyWebTarget target;
        ResteasyClientBuilder clientBuilder = new ResteasyClientBuilder();
        for (Object provider : providers) {
            clientBuilder.register(provider);
        }
        ResteasyClient client = clientBuilder.build();
        ResteasyWebTarget rtarget = target = client.target(this.apmUri);
        return (T)rtarget.proxy(proxyType);
    }
}

