/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.datadog.apm.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.inject.Inject;
import org.honton.chas.datadog.apm.SpanBuilder;
import org.honton.chas.datadog.apm.Tracer;

public class ProxyFactory {
    @Inject
    Tracer tracer;

    public <T> T createProxy(T instance, Class<T> iface) {
        return (T)this.createProxy(instance, new Class[]{iface});
    }

    public Object createProxy(Object instance, Class<?> ... ifaces) {
        InvocationHandler handler = this.createInvocationHandler(instance);
        return Proxy.newProxyInstance(instance.getClass().getClassLoader(), ifaces, handler);
    }

    private InvocationHandler createInvocationHandler(final Object instance) {
        return new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                SpanBuilder span = ProxyFactory.this.tracer.createSpan();
                try {
                    Object object = method.invoke(instance, args);
                    return object;
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    span.exception(cause);
                    throw cause;
                }
                finally {
                    span.resource(method.getDeclaringClass().getCanonicalName()).operation(method.getName());
                    ProxyFactory.this.tracer.closeSpan(span);
                }
            }
        };
    }
}

