/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.datadog.apm;

import java.beans.ConstructorProperties;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.honton.chas.datadog.apm.api.Span;

public class SpanBuilder {
    private static final Random ID_GENERATOR = new Random();
    private final SpanBuilder parent;
    private String resource;
    private String operation;
    private final long traceId;
    private final Long parentId;
    private final long spanId;
    private String type;
    private Map<String, String> meta;
    private Map<String, Number> metrics;
    private int error;
    private final long start = System.nanoTime();
    private static final long WALL_OFFSET = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis()) - System.nanoTime();

    public SpanBuilder metric(String key, Number value) {
        if (this.metrics == null) {
            this.metrics = new HashMap<String, Number>();
        }
        this.metrics.put(key, value);
        return this;
    }

    public SpanBuilder meta(String key, String value) {
        if (this.meta == null) {
            this.meta = new HashMap<String, String>();
        }
        this.meta.put(key, value);
        return this;
    }

    public SpanBuilder exception(Throwable e) {
        this.meta("error.msg", e.getMessage());
        String exception = e.getClass().getCanonicalName();
        this.error = exception.hashCode();
        this.meta.put("error.type", exception);
        this.meta.put("error.stack", SpanBuilder.exceptionToString(e));
        return this;
    }

    public SpanBuilder createChild() {
        return new SpanBuilder(this, this.traceId, this.spanId, SpanBuilder.createId());
    }

    public static SpanBuilder createRoot() {
        long traceId = SpanBuilder.createId();
        return new SpanBuilder(null, traceId, null, traceId);
    }

    public static SpanBuilder createChild(long traceId, long parentSpanId) {
        return new SpanBuilder(null, traceId, parentSpanId, SpanBuilder.createId());
    }

    public Span finishSpan(String service) {
        return new Span(service, this.resource, this.operation, this.traceId, this.parentId, this.spanId, this.type, this.meta != null ? SpanBuilder.copyOf(this.meta) : null, this.metrics != null ? SpanBuilder.copyOf(this.metrics) : null, this.error, WALL_OFFSET + this.start, System.nanoTime() - this.start);
    }

    private static <K, V> Map<K, V> copyOf(Map<K, V> map) {
        return Collections.unmodifiableMap(new HashMap<K, V>(map));
    }

    private static long createId() {
        long high = (long)ID_GENERATOR.nextInt() & Integer.MAX_VALUE;
        long low = (long)ID_GENERATOR.nextInt() & 0xFFFFFFFFL;
        return high << 32 | low;
    }

    private static String exceptionToString(Throwable ex) {
        StringWriter errors = new StringWriter();
        ex.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }

    public SpanBuilder parent() {
        return this.parent;
    }

    public String resource() {
        return this.resource;
    }

    public String operation() {
        return this.operation;
    }

    public long traceId() {
        return this.traceId;
    }

    public Long parentId() {
        return this.parentId;
    }

    public long spanId() {
        return this.spanId;
    }

    public String type() {
        return this.type;
    }

    public Map<String, String> meta() {
        return this.meta;
    }

    public Map<String, Number> metrics() {
        return this.metrics;
    }

    public int error() {
        return this.error;
    }

    public long start() {
        return this.start;
    }

    public SpanBuilder resource(String resource) {
        this.resource = resource;
        return this;
    }

    public SpanBuilder operation(String operation) {
        this.operation = operation;
        return this;
    }

    public SpanBuilder type(String type) {
        this.type = type;
        return this;
    }

    public SpanBuilder meta(Map<String, String> meta) {
        this.meta = meta;
        return this;
    }

    public SpanBuilder metrics(Map<String, Number> metrics) {
        this.metrics = metrics;
        return this;
    }

    public SpanBuilder error(int error) {
        this.error = error;
        return this;
    }

    @ConstructorProperties(value={"parent", "traceId", "parentId", "spanId"})
    public SpanBuilder(SpanBuilder parent, long traceId, Long parentId, long spanId) {
        this.parent = parent;
        this.traceId = traceId;
        this.parentId = parentId;
        this.spanId = spanId;
    }

    public static interface Augmenter {
        public void augment(SpanBuilder var1);
    }
}

