/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.datadog.apm.jaxrs;

import java.io.IOException;
import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import org.honton.chas.datadog.apm.Tracer;

public class TraceClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private Tracer tracer;

    @Inject
    void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public void filter(final ClientRequestContext requestContext) throws IOException {
        URI uri = requestContext.getUri();
        this.tracer.exportSpan("CS:" + uri.getHost() + ':' + uri.getPort(), requestContext.getMethod() + ':' + uri.getPath().toLowerCase(), new Tracer.HeaderMutator(){

            @Override
            public void setValue(String name, String value) {
                requestContext.getHeaders().putSingle((Object)name, (Object)value);
            }
        });
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        int status = responseContext.getStatus();
        if (status < 200 || status >= 400) {
            this.tracer.getCurrentSpan().error(status);
        }
        this.tracer.closeCurrentSpan();
    }
}

