/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.datadog.apm;

import java.beans.ConstructorProperties;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.honton.chas.datadog.apm.api.Span;

public class SpanBuilder {
    private static final SecureRandom ID_GENERATOR = new SecureRandom();
    private final SpanBuilder parent;
    private String resource;
    private String operation;
    private final long traceId;
    private final Long parentId;
    private final long spanId;
    private String type;
    private Map<String, String> meta;
    private Map<String, Number> metrics;
    private boolean error;
    private final long start = System.nanoTime();
    private static final long WALL_OFFSET = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis()) - System.nanoTime();

    public SpanBuilder metric(String key, Number value) {
        if (this.metrics == null) {
            this.metrics = new HashMap<String, Number>();
        }
        this.metrics.put(key, value);
        return this;
    }

    public SpanBuilder meta(String key, String value) {
        if (this.meta == null) {
            this.meta = new HashMap<String, String>();
        }
        this.meta.put(key, value);
        return this;
    }

    public SpanBuilder exception(Throwable e) {
        this.meta("error.msg", e.getMessage());
        String exception = e.getClass().getCanonicalName();
        this.error = true;
        this.meta.put("error.type", exception);
        this.meta.put("error.stack", SpanBuilder.exceptionToString(e));
        return this;
    }

    public SpanBuilder createChild() {
        return new SpanBuilder(this, this.traceId, this.spanId, SpanBuilder.createId());
    }

    public static SpanBuilder createRoot() {
        return new SpanBuilder(null, SpanBuilder.createId(), null, SpanBuilder.createId());
    }

    public static SpanBuilder createChild(long traceId, long parentSpanId) {
        return new SpanBuilder(null, traceId, parentSpanId, SpanBuilder.createId());
    }

    public Span finishSpan(String service) {
        if (service == null) {
            throw new IllegalStateException("service is null");
        }
        if (this.resource == null) {
            throw new IllegalStateException("resource is null");
        }
        if (this.operation == null) {
            throw new IllegalStateException("operation is null");
        }
        return new Span(service, this.resource, this.operation, this.traceId, this.parentId, this.spanId, this.typeOrDefault(), SpanBuilder.copyOf(this.meta), SpanBuilder.copyOf(this.metrics), this.error ? 1 : 0, WALL_OFFSET + this.start, System.nanoTime() - this.start);
    }

    private String typeOrDefault() {
        return this.type == null || this.type.isEmpty() ? "unknown" : this.type;
    }

    private static <K, V> Map<K, V> copyOf(Map<K, V> map) {
        return map != null ? Collections.unmodifiableMap(new HashMap<K, V>(map)) : null;
    }

    private static long createId() {
        long high = (long)ID_GENERATOR.nextInt() & Integer.MAX_VALUE;
        long low = (long)ID_GENERATOR.nextInt() & 0xFFFFFFFFL;
        return high << 32 | low;
    }

    private static String exceptionToString(Throwable ex) {
        StringWriter errors = new StringWriter();
        ex.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }

    public SpanContext exportSpan() {
        return new SpanContext();
    }

    public SpanBuilder parent() {
        return this.parent;
    }

    public String resource() {
        return this.resource;
    }

    public String operation() {
        return this.operation;
    }

    public long traceId() {
        return this.traceId;
    }

    public Long parentId() {
        return this.parentId;
    }

    public long spanId() {
        return this.spanId;
    }

    public String type() {
        return this.type;
    }

    public Map<String, String> meta() {
        return this.meta;
    }

    public Map<String, Number> metrics() {
        return this.metrics;
    }

    public boolean error() {
        return this.error;
    }

    public long start() {
        return this.start;
    }

    public SpanBuilder resource(String resource) {
        this.resource = resource;
        return this;
    }

    public SpanBuilder operation(String operation) {
        this.operation = operation;
        return this;
    }

    public SpanBuilder type(String type) {
        this.type = type;
        return this;
    }

    public SpanBuilder meta(Map<String, String> meta) {
        this.meta = meta;
        return this;
    }

    public SpanBuilder metrics(Map<String, Number> metrics) {
        this.metrics = metrics;
        return this;
    }

    public SpanBuilder error(boolean error) {
        this.error = error;
        return this;
    }

    @ConstructorProperties(value={"parent", "traceId", "parentId", "spanId"})
    public SpanBuilder(SpanBuilder parent, long traceId, Long parentId, long spanId) {
        this.parent = parent;
        this.traceId = traceId;
        this.parentId = parentId;
        this.spanId = spanId;
    }

    public class SpanContext {
        public SpanBuilder importSpan(String resource, String operation) {
            return new SpanBuilder(null, SpanBuilder.this.traceId, SpanBuilder.this.spanId, SpanBuilder.createId()).resource(resource).operation(operation);
        }
    }
}

