/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.datadog.apm.cdi;

import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.honton.chas.datadog.apm.SpanBuilder;
import org.honton.chas.datadog.apm.TraceOperation;
import org.honton.chas.datadog.apm.cdi.TracerImpl;

@TraceOperation
@Interceptor
@Priority(value=999)
public class TraceInterceptor {
    @Inject
    TracerImpl tracer;

    @AroundInvoke
    public Object invokeWithReporting(InvocationContext ctx) throws Exception {
        SpanBuilder span = this.tracer.createSpan();
        try {
            Object object = ctx.proceed();
            return object;
        }
        catch (Exception e) {
            span.exception(e);
            throw e;
        }
        finally {
            Method method = ctx.getMethod();
            span.resource(method.getDeclaringClass().getSimpleName()).operation(method.getName()).type(TraceInterceptor.getType(method));
            this.tracer.closeSpan(span);
        }
    }

    private static String getType(Method method) {
        TraceOperation traceOperation = method.getAnnotation(TraceOperation.class);
        if (traceOperation == null && (traceOperation = method.getDeclaringClass().getAnnotation(TraceOperation.class)) == null) {
            return null;
        }
        return traceOperation.type().isEmpty() ? "unknown" : traceOperation.type();
    }
}

