/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.datadog.apm.cdi;

import java.util.concurrent.Callable;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.honton.chas.datadog.apm.SpanBuilder;
import org.honton.chas.datadog.apm.TraceConfiguration;
import org.honton.chas.datadog.apm.Tracer;
import org.honton.chas.datadog.apm.api.Span;
import org.honton.chas.datadog.apm.sender.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class TracerImpl
implements Tracer {
    private static final Logger log = LoggerFactory.getLogger(TracerImpl.class);
    private final ThreadLocal<SpanBuilder> CURRENT_SPAN = new ThreadLocal();
    @Inject
    private Writer writer;
    private String service;

    @Inject
    void setTraceConfiguration(TraceConfiguration configuration) {
        this.service = configuration.getService();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T executeCallable(String resource, String operation, Callable<T> callable) {
        SpanBuilder builder = this.createSpan(resource, operation);
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            builder.exception(e);
            throw e;
        }
        finally {
            this.closeSpan(builder);
        }
    }

    @Override
    public void executeRunnable(String resource, String operation, Runnable runnable) {
        SpanBuilder builder = this.createSpan(resource, operation);
        try {
            runnable.run();
        }
        catch (Exception e) {
            builder.exception(e);
            throw e;
        }
        finally {
            this.closeSpan(builder);
        }
    }

    @Override
    public SpanBuilder getCurrentSpan() {
        return this.CURRENT_SPAN.get();
    }

    @Override
    public SpanBuilder.SpanContext exportCurrentSpan() {
        return this.CURRENT_SPAN.get().exportSpan();
    }

    @Override
    public SpanBuilder importCurrentSpan(SpanBuilder.SpanContext spanContext, String resource, String operation) {
        SpanBuilder span = spanContext.importSpan(resource, operation);
        this.CURRENT_SPAN.set(span);
        return span;
    }

    @Override
    public SpanBuilder importSpan(Tracer.HeaderAccessor headerAccessor) {
        SpanBuilder current;
        String traceIdHeader = headerAccessor.getValue("x-ddtrace-parent_trace_id");
        String spanIdHeader = headerAccessor.getValue("x-ddtrace-parent_span_id");
        if (traceIdHeader == null || spanIdHeader == null) {
            current = SpanBuilder.createRoot();
        } else {
            try {
                current = SpanBuilder.createChild(Long.parseUnsignedLong(traceIdHeader), Long.parseUnsignedLong(spanIdHeader));
            }
            catch (NumberFormatException ignoreParseFailure) {
                current = SpanBuilder.createRoot();
            }
        }
        this.CURRENT_SPAN.set(current);
        return current;
    }

    @Override
    public void exportSpan(String resource, String operation, Tracer.HeaderMutator headerAccessor) {
        SpanBuilder span = this.createSpan(resource, operation).type("web");
        headerAccessor.setValue("x-ddtrace-parent_trace_id", Long.toUnsignedString(span.traceId()));
        headerAccessor.setValue("x-ddtrace-parent_span_id", Long.toUnsignedString(span.spanId()));
    }

    @Override
    public SpanBuilder createSpan() {
        SpanBuilder parent = this.CURRENT_SPAN.get();
        SpanBuilder span = parent == null ? SpanBuilder.createRoot() : parent.createChild();
        this.CURRENT_SPAN.set(span);
        return span;
    }

    @Override
    public void closeCurrentSpan() {
        this.closeSpan(this.CURRENT_SPAN.get());
    }

    @Override
    public void closeSpan(SpanBuilder current) {
        try {
            this.CURRENT_SPAN.set(current.parent());
            Span span = current.finishSpan(this.service);
            this.queueSpan(span);
        }
        catch (RuntimeException re) {
            log.error("Exception in tracing", (Throwable)re);
        }
    }

    void queueSpan(Span span) {
        this.writer.queue(span);
    }

    private SpanBuilder createSpan(String resource, String operation) {
        return this.createSpan().resource(resource).operation(operation);
    }
}

