/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.datadog.apm.servlet;

import java.io.IOException;
import java.net.URLDecoder;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.honton.chas.datadog.apm.SpanBuilder;
import org.honton.chas.datadog.apm.Tracer;

@WebFilter(value={"/*"})
public class TraceServletFilter
implements Filter {
    private Tracer tracer;

    @Inject
    void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        SpanBuilder sb = this.tracer.importSpan(name -> req.getHeader(name));
        try {
            sb.resource(TraceServletFilter.normalize(req.getServerName()) + ':' + req.getServerPort()).operation(req.getMethod() + ' ' + URLDecoder.decode(req.getRequestURI(), "UTF-8")).type("web");
            filterChain.doFilter(request, response);
        }
        catch (Throwable throwable) {
            int status = resp.getStatus();
            sb.error(status < 200 || status >= 400);
            this.tracer.closeSpan(sb);
            throw throwable;
        }
        int status = resp.getStatus();
        sb.error(status < 200 || status >= 400);
        this.tracer.closeSpan(sb);
    }

    private static String normalize(String host) {
        if (Character.isDigit(host.charAt(0))) {
            return ':' + host;
        }
        return host;
    }

    public void destroy() {
    }
}

