/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.datadog.apm.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.msgpack.jackson.dataformat.MessagePackFactory;

@Provider
@Produces(value={"application/msgpack"})
@Consumes(value={"application/msgpack"})
public class MsgPackProvider
extends JacksonJsonProvider {
    private static final ObjectMapper MINIMAL_OBJECT_MAPPER = MsgPackProvider.createMinimalObjectMapper();

    private static ObjectMapper createMinimalObjectMapper() {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return mapper;
    }

    public MsgPackProvider() {
        super(MINIMAL_OBJECT_MAPPER);
    }

    protected boolean hasMatchingMediaType(MediaType mediaType) {
        return "application".equals(mediaType.getType()) && "msgpack".equals(mediaType.getSubtype());
    }
}

