/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.datadog.apm.jaxrs;

import java.io.IOException;
import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.ext.Provider;
import org.honton.chas.datadog.apm.Tracer;

@Provider
public class TraceClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private Tracer tracer;

    @Inject
    void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public void filter(final ClientRequestContext req) throws IOException {
        URI uri = req.getUri();
        this.tracer.exportSpan(TraceClientFilter.normalize(uri.getHost()) + ':' + uri.getPort(), req.getMethod() + ' ' + uri.getPath(), new Tracer.HeaderMutator(){

            @Override
            public void setValue(String name, String value) {
                req.getHeaders().putSingle((Object)name, (Object)value);
            }
        });
    }

    private static String normalize(String host) {
        if (Character.isDigit(host.charAt(0))) {
            return ':' + host;
        }
        return host;
    }

    public void filter(ClientRequestContext req, ClientResponseContext resp) throws IOException {
        int status = resp.getStatus();
        this.tracer.getCurrentSpan().error(status < 200 || status >= 400);
        this.tracer.closeCurrentSpan();
    }
}

