/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.datadog.apm.jaxrs;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.honton.chas.datadog.apm.SpanBuilder;
import org.honton.chas.datadog.apm.TraceOperation;
import org.honton.chas.datadog.apm.Tracer;

@Provider
@Priority(value=999)
public class TraceContainerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private Tracer tracer;
    @Context
    ResourceInfo resourceInfo;

    @Inject
    void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    private TraceOperation getTraceOperationAnnotation() {
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        TraceOperation traceOperation = resourceMethod.getAnnotation(TraceOperation.class);
        if (traceOperation != null) {
            return traceOperation;
        }
        Class resourceClass = this.resourceInfo.getResourceClass();
        return resourceClass.getAnnotation(TraceOperation.class);
    }

    public void filter(ContainerRequestContext req) throws IOException {
        TraceOperation traceOperation = this.getTraceOperationAnnotation();
        if (traceOperation == null || traceOperation.value()) {
            SpanBuilder sb = this.tracer.importSpan(name -> req.getHeaderString(name));
            sb.resource(this.resourceInfo.getResourceClass().getSimpleName()).operation(this.resourceInfo.getResourceMethod().getName());
            sb.type(traceOperation != null && !traceOperation.type().isEmpty() ? traceOperation.type() : "web");
        }
    }

    public void filter(ContainerRequestContext req, ContainerResponseContext resp) throws IOException {
        TraceOperation traceOperation = this.getTraceOperationAnnotation();
        if (traceOperation == null || traceOperation.value()) {
            SpanBuilder currentSpan = this.tracer.getCurrentSpan();
            int status = resp.getStatus();
            if (status < 200 || status >= 400) {
                currentSpan.error(true);
            }
            this.tracer.closeSpan(currentSpan);
        }
    }
}

