/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.datadog.apm.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.inject.Inject;
import org.honton.chas.datadog.apm.SpanBuilder;
import org.honton.chas.datadog.apm.TraceOperation;
import org.honton.chas.datadog.apm.Tracer;

public class TraceProxyFactory {
    @Inject
    Tracer tracer;

    public <T> T createProxy(T instance, Class<T> iface) {
        return (T)this.createProxy(instance, new Class[]{iface});
    }

    public Object createProxy(Object instance, Class<?> ... ifaces) {
        InvocationHandler handler = this.createInvocationHandler(instance);
        return Proxy.newProxyInstance(instance.getClass().getClassLoader(), ifaces, handler);
    }

    private static boolean shouldTrace(Method method) {
        TraceOperation traceOperation = method.getAnnotation(TraceOperation.class);
        if (traceOperation == null && (traceOperation = method.getDeclaringClass().getAnnotation(TraceOperation.class)) == null) {
            return true;
        }
        return traceOperation.value();
    }

    private InvocationHandler createInvocationHandler(final Object instance) {
        return new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (!TraceProxyFactory.shouldTrace(method)) {
                    return method.invoke(instance, args);
                }
                SpanBuilder span = TraceProxyFactory.this.tracer.createSpan();
                try {
                    Object object = method.invoke(instance, args);
                    return object;
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    span.exception(cause);
                    throw cause;
                }
                finally {
                    span.resource(method.getDeclaringClass().getCanonicalName()).operation(method.getName());
                    TraceProxyFactory.this.tracer.closeSpan(span);
                }
            }
        };
    }
}

