/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.dependency.analyzescope;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.honton.chas.dependency.analyzescope.AbstractAnalyzeScopeMojo;

@Mojo(name="test", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class AnalyzeTestMojo
extends AbstractAnalyzeScopeMojo {
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true, readonly=true)
    private File testClasses;
    private Artifact testArtifact;

    private static Artifact createTestArtifact(Artifact mainArtifact) {
        return new DefaultArtifact(mainArtifact.getGroupId(), mainArtifact.getArtifactId(), mainArtifact.getVersion(), "test", mainArtifact.getType(), "test", mainArtifact.getArtifactHandler());
    }

    @Override
    boolean skip() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping dependency-check:test execution");
            return true;
        }
        if (this.testClasses == null || !this.testClasses.exists()) {
            this.getLog().info((CharSequence)"No test classes directory");
            return true;
        }
        this.testArtifact = AnalyzeTestMojo.createTestArtifact(this.project.getArtifact());
        this.testArtifact.setFile(this.testClasses);
        return false;
    }

    @Override
    Artifact workingArtifact() {
        return this.testArtifact;
    }

    @Override
    Collection<Artifact> impliedArtifacts() {
        Artifact mainArtifact = this.project.getArtifact();
        return Arrays.asList(mainArtifact, this.testArtifact);
    }

    @Override
    Set<String> getDeclaredScopes() {
        return Collections.singleton("test");
    }

    @Override
    Set<String> getClasspathScopes() {
        return Set.of("compile", "provided", "system", "test");
    }
}

