/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.analyzer.asm.visitors;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.codehaus.plexus.util.IOUtil;
import org.honton.chas.analyzer.asm.visitors.ConstantPoolParser;
import org.honton.chas.analyzer.asm.visitors.DefaultAnnotationVisitor;
import org.honton.chas.analyzer.asm.visitors.DefaultClassVisitor;
import org.honton.chas.analyzer.asm.visitors.DefaultFieldVisitor;
import org.honton.chas.analyzer.asm.visitors.DefaultMethodVisitor;
import org.honton.chas.analyzer.asm.visitors.DefaultSignatureVisitor;
import org.honton.chas.analyzer.asm.visitors.ResultCollector;
import org.honton.chas.analyzer.spi.ClassFileVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class DependencyClassFileVisitor
implements ClassFileVisitor {
    private final ResultCollector resultCollector;

    public DependencyClassFileVisitor() {
        this.resultCollector = new ResultCollector();
    }

    public DependencyClassFileVisitor(Set<String> classes) {
        this.resultCollector = new ResultCollector(classes);
    }

    @Override
    public void visitClass(String className, InputStream in) {
        try {
            byte[] byteCode = IOUtil.toByteArray((InputStream)in);
            ClassReader reader = new ClassReader(byteCode);
            Set<String> constantPoolClassRefs = ConstantPoolParser.getConstantPoolClassReferences(byteCode);
            for (String string : constantPoolClassRefs) {
                this.resultCollector.addName(string);
            }
            DefaultAnnotationVisitor annotationVisitor = new DefaultAnnotationVisitor(this.resultCollector);
            DefaultSignatureVisitor signatureVisitor = new DefaultSignatureVisitor(this.resultCollector);
            DefaultFieldVisitor fieldVisitor = new DefaultFieldVisitor(annotationVisitor, this.resultCollector);
            DefaultMethodVisitor mv = new DefaultMethodVisitor(annotationVisitor, signatureVisitor, this.resultCollector);
            DefaultClassVisitor classVisitor = new DefaultClassVisitor(signatureVisitor, annotationVisitor, fieldVisitor, mv, this.resultCollector);
            reader.accept((ClassVisitor)classVisitor, 0);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("Unable to process: " + className);
        }
    }

    public Set<String> getDependencies() {
        return this.resultCollector.getDependencies();
    }
}

