/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.dependency.analyzescope;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.honton.chas.analyzer.api.DependencyAnalyzer;
import org.honton.chas.analyzer.api.LocationCollector;
import org.honton.chas.analyzer.asm.AsmDependencyAnalyzer;
import org.honton.chas.analyzer.asm.AsmLocationCollector;
import org.honton.chas.dependency.analyzescope.AnalyzeClassUsage;

public abstract class AbstractAnalyzeScopeMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(property="dependency-check.fail", defaultValue="true")
    private boolean failOnWarning;
    @Parameter(property="dependency-check.skip", defaultValue="false")
    boolean skip;
    @Parameter
    private List<String> ignoreDependencies;
    @Parameter
    private List<String> ignoreUsedUndeclaredDependencies;
    @Parameter
    private List<String> ignoreUnusedDeclaredDependencies;
    private LocationCollector locationCollector = new AsmLocationCollector();
    private DependencyAnalyzer dependencyAnalyzer = new AsmDependencyAnalyzer();

    public void execute() throws MojoExecutionException {
        if (this.skip()) {
            return;
        }
        boolean warning = this.checkDependencies();
        if (warning && this.failOnWarning) {
            throw new MojoExecutionException("Dependency problems found");
        }
    }

    abstract boolean skip();

    abstract Artifact workingArtifact();

    abstract Collection<Artifact> impliedArtifacts();

    abstract Set<String> getDeclaredScopes();

    abstract Set<String> getClasspathScopes();

    private Set<Artifact> getDependencyArtifactsByScope(Collection<String> acceptableScopes) {
        HashSet<Artifact> scopedArtifacts = new HashSet<Artifact>();
        for (Artifact artifact : this.project.getDependencyArtifacts()) {
            if (!acceptableScopes.contains(artifact.getScope())) continue;
            scopedArtifacts.add(artifact);
        }
        return scopedArtifacts;
    }

    private boolean checkDependencies() throws MojoExecutionException {
        try {
            AnalyzeClassUsage analyzeClassUsage = this.analyzeClassUsage();
            boolean reported = this.logAnalysis(analyzeClassUsage);
            if (!reported) {
                this.getLog().info((CharSequence)"No dependency problems found");
            }
            return reported;
        }
        catch (IOException ioException) {
            throw new MojoExecutionException("Analysis failed", (Exception)ioException);
        }
    }

    private AnalyzeClassUsage analyzeClassUsage() throws IOException {
        Artifact artifact = this.project.getArtifact();
        if (artifact.getFile() == null) {
            String outputDirectory = this.project.getBuild().getOutputDirectory();
            this.getLog().warn((CharSequence)("Setting File " + outputDirectory + " for Artifact " + String.valueOf(artifact)));
            artifact.setFile(new File(outputDirectory));
        }
        AnalyzeClassUsage analyzer = new AnalyzeClassUsage(this.locationCollector, this.dependencyAnalyzer);
        analyzer.addImpliedDependencies(this.getLog(), this.impliedArtifacts());
        Set<String> acceptableScopes = this.getDeclaredScopes();
        Set<Artifact> declaredDependencies = this.getDependencyArtifactsByScope(acceptableScopes);
        analyzer.addDeclaredDependencies(this.getLog(), declaredDependencies);
        analyzer.addUsedClassNames(this.getLog(), this.workingArtifact());
        analyzer.scanDeclaredDependencies(declaredDependencies);
        analyzer.setDeclaredDependencies(declaredDependencies);
        analyzer.removeIgnoreUnusedDeclaredDependencies(this.ignoreUnusedDeclaredDependencies);
        analyzer.removeIgnoreUnusedDeclaredDependencies(this.ignoreDependencies);
        Set<String> classpathScopes = this.getClasspathScopes();
        Set<Artifact> classpathDependencies = this.getDependencyArtifactsByScope(classpathScopes);
        classpathDependencies.add(artifact);
        analyzer.setClasspathDependencies(classpathDependencies);
        analyzer.removeIgnoredUsedUndeclaredDependencies(this.ignoreUsedUndeclaredDependencies);
        analyzer.removeIgnoredUsedUndeclaredDependencies(this.ignoreDependencies);
        return analyzer;
    }

    private boolean logAnalysis(AnalyzeClassUsage analyzeClassUsage) {
        boolean reported = analyzeClassUsage.logMultipleDefinitions(this.getLog());
        reported |= analyzeClassUsage.logDeclaredButUnused(this.getLog());
        return reported |= analyzeClassUsage.logUsedButUndeclared(this.getLog());
    }
}

