/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.dependency.analyzescope;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.artifact.filter.StrictPatternExcludesArtifactFilter;
import org.honton.chas.analyzer.api.DependencyAnalyzer;
import org.honton.chas.analyzer.api.LocationCollector;

class AnalyzeClassUsage {
    private static final Artifact TRANSITIVE = AnalyzeClassUsage.createTransitive();
    private final LocationCollector locationCollector;
    private final DependencyAnalyzer dependencyAnalyzer;
    private final Map<String, Artifact> classNameToArtifact;
    private final Map<Artifact, Map<String, Set<String>>> usedDependencies;
    private final Map<String, Artifact> resolvedClasses;
    private final Map<String, List<Artifact>> multipleDefinition;
    private final List<Artifact> impliedDependencies;
    private final Set<Artifact> declaredButUnused;
    private final Set<Artifact> usedButUndeclared;

    AnalyzeClassUsage(LocationCollector locationCollector, DependencyAnalyzer dependencyAnalyzer) {
        this.locationCollector = locationCollector;
        this.dependencyAnalyzer = dependencyAnalyzer;
        this.classNameToArtifact = new HashMap<String, Artifact>();
        this.usedDependencies = new HashMap<Artifact, Map<String, Set<String>>>();
        this.resolvedClasses = new HashMap<String, Artifact>();
        this.multipleDefinition = new HashMap<String, List<Artifact>>();
        this.impliedDependencies = new ArrayList<Artifact>();
        this.declaredButUnused = new HashSet<Artifact>();
        this.usedButUndeclared = new HashSet<Artifact>();
    }

    private static Artifact createTransitive() {
        return new DefaultArtifact("unknown.groupId", "unknown-artifactId", "unknown.version", "compile", "jar", null, (ArtifactHandler)new DefaultArtifactHandler());
    }

    void addImpliedDependencies(Log log, Collection<Artifact> impliedDependencies) {
        for (Artifact artifact : impliedDependencies) {
            if (!this.addClassesToArtifactMapping(log, artifact)) continue;
            this.impliedDependencies.add(artifact);
        }
        this.impliedDependencies.add(TRANSITIVE);
    }

    void addDeclaredDependencies(Log log, Collection<Artifact> dependencyArtifacts) {
        for (Artifact artifact : dependencyArtifacts) {
            this.addClassesToArtifactMapping(log, artifact);
        }
    }

    private boolean addClassesToArtifactMapping(Log log, Artifact artifact) {
        Set<String> classNames = this.locationCollector.list(artifact.getFile().toPath(), log);
        for (String className : classNames) {
            Artifact prior = this.classNameToArtifact.put(className, artifact);
            if (prior == null) continue;
            List artifacts = this.multipleDefinition.computeIfAbsent(className, cn -> {
                ArrayList<Artifact> multiple = new ArrayList<Artifact>();
                multiple.add(prior);
                return multiple;
            });
            artifacts.add(artifact);
        }
        return !classNames.isEmpty();
    }

    public void scanDeclaredDependencies(Set<Artifact> declaredDependencies) {
        for (Artifact declaredDependency : declaredDependencies) {
            if (this.usedDependencies.containsKey(declaredDependency)) continue;
            this.declaredButUnused.add(declaredDependency);
        }
    }

    public void addUsedClassNames(Log log, Artifact artifact) {
        Map<String, Set<String>> classDependencies = this.dependencyAnalyzer.analyze(artifact.getFile().toPath(), log);
        if (!classDependencies.isEmpty()) {
            this.usedDependencies.put(artifact, classDependencies);
            for (Map.Entry<String, Set<String>> entry : classDependencies.entrySet()) {
                this.resolveClass(log, artifact, entry.getKey(), entry.getValue());
            }
        }
    }

    private void resolveClass(Log log, Artifact artifact, String className, Set<String> dependentClassNames) {
        Artifact prior = this.resolvedClasses.put(className, artifact);
        if (prior != null) {
            if (!prior.equals((Object)artifact)) {
                log.error((CharSequence)("Duplicate artifact for " + className + "; " + String.valueOf(prior) + " and " + String.valueOf(artifact)));
            }
        } else {
            for (String dependentClassName : dependentClassNames) {
                this.resolveDependentClass(log, dependentClassName);
            }
        }
    }

    private void resolveDependentClass(Log log, String dependentClassName) {
        Artifact dependent = this.findDependency(log, dependentClassName);
        if (dependent != null) {
            log.debug((CharSequence)("Found " + dependentClassName + " in " + String.valueOf(dependent)));
            Map analyzedArtifact = this.usedDependencies.computeIfAbsent(dependent, da -> this.dependencyAnalyzer.analyze(da.getFile().toPath(), log));
            Set dependentClasses = (Set)analyzedArtifact.get(dependentClassName);
            if (dependentClasses != null) {
                this.resolveClass(log, dependent, dependentClassName, dependentClasses);
            }
        }
    }

    private Artifact findDependency(Log log, String dependentClassName) {
        Artifact dependent = this.classNameToArtifact.get(dependentClassName);
        if (dependent != null) {
            return dependent.equals((Object)TRANSITIVE) ? null : dependent;
        }
        if (!dependentClassName.startsWith("java.") && !dependentClassName.startsWith("javax.")) {
            log.debug((CharSequence)("Could not find artifact containing " + dependentClassName));
        }
        this.resolvedClasses.put(dependentClassName, TRANSITIVE);
        this.classNameToArtifact.put(dependentClassName, TRANSITIVE);
        return null;
    }

    public void setDeclaredDependencies(Collection<Artifact> declaredDependencies) {
        for (Artifact declaredDependency : declaredDependencies) {
            if (this.usedDependencies.containsKey(declaredDependency)) continue;
            this.declaredButUnused.add(declaredDependency);
        }
    }

    public void setClasspathDependencies(Set<Artifact> classpathDependencies) {
        for (Artifact usedDependency : this.usedDependencies.keySet()) {
            if (classpathDependencies.contains(usedDependency)) continue;
            this.usedButUndeclared.add(usedDependency);
        }
    }

    public void removeIgnoreUnusedDeclaredDependencies(List<String> ignoreUnusedDeclaredDependencies) {
        this.removeIgnored(this.declaredButUnused, ignoreUnusedDeclaredDependencies);
    }

    public void removeIgnoredUsedUndeclaredDependencies(List<String> ignoredUsedUndeclaredDependencies) {
        this.usedButUndeclared.removeAll(this.impliedDependencies);
        this.removeIgnored(this.usedButUndeclared, ignoredUsedUndeclaredDependencies);
    }

    private void removeIgnored(Set<Artifact> logSet, List<String> ignore) {
        if (ignore != null && !ignore.isEmpty()) {
            StrictPatternExcludesArtifactFilter filter = new StrictPatternExcludesArtifactFilter(ignore);
            logSet.removeIf(arg_0 -> AnalyzeClassUsage.lambda$removeIgnored$2((ArtifactFilter)filter, arg_0));
        }
    }

    public boolean logMultipleDefinitions(Log log) {
        if (this.multipleDefinition.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, List<Artifact>> definition : this.multipleDefinition.entrySet()) {
            log.warn((CharSequence)("Multiple definitions of " + definition.getKey()));
            for (Artifact location : definition.getValue()) {
                log.warn((CharSequence)("    " + String.valueOf(location)));
            }
        }
        return true;
    }

    public boolean logDeclaredButUnused(Log log) {
        return this.logCollectionContents(log, "Unused declared dependencies found:", this.declaredButUnused);
    }

    public boolean logUsedButUndeclared(Log log) {
        return this.logCollectionContents(log, "Used undeclared dependencies found:", this.usedButUndeclared);
    }

    private boolean logCollectionContents(Log log, String message, Set<Artifact> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        log.warn((CharSequence)message);
        for (Artifact artifact : collection) {
            log.warn((CharSequence)("    " + String.valueOf(artifact)));
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$removeIgnored$2(ArtifactFilter filter, Artifact artifact) {
        return !filter.include(artifact);
    }
}

