/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.analyzer.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import lombok.Generated;
import org.codehaus.plexus.util.DirectoryScanner;
import org.honton.chas.analyzer.spi.ClassFileVisitor;

public final class ClassFileVisitorUtils {
    private static final String DOT_CLASS = ".class";

    public static void accept(Path path, Function<String, ClassFileVisitor> visitorFactory, BiConsumer<String, IOException> handler) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            ClassFileVisitorUtils.acceptDirectory(path, visitorFactory, handler);
        } else if (Files.isReadable(path)) {
            ClassFileVisitorUtils.acceptJar(path, visitorFactory, handler);
        } else {
            throw new IllegalArgumentException("Location " + String.valueOf(path) + " is not a directory and not a readable jar");
        }
    }

    private static void acceptJar(Path jar, Function<String, ClassFileVisitor> visitorFactory, BiConsumer<String, IOException> handler) {
        try {
            ClassFileVisitorUtils.acceptJar(Files.newInputStream(jar, new OpenOption[0]), visitorFactory);
        }
        catch (IOException ioException) {
            handler.accept(jar.toString(), ioException);
        }
    }

    private static void acceptJar(InputStream is, Function<String, ClassFileVisitor> visitorFactory) throws IOException {
        try (JarInputStream in = new JarInputStream(is);){
            JarEntry entry;
            while ((entry = in.getNextJarEntry()) != null) {
                String path = entry.getName();
                if (!path.endsWith(DOT_CLASS) || path.indexOf(45) != -1) continue;
                String className = ClassFileVisitorUtils.pathToClassName(path);
                visitorFactory.apply(className).visitClass(className, in);
            }
        }
    }

    private static void acceptDirectory(Path directory, Function<String, ClassFileVisitor> visitorFactory, BiConsumer<String, IOException> handler) {
        String[] paths;
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory.toFile());
        scanner.setIncludes(new String[]{"**/*.class"});
        scanner.scan();
        for (String path : paths = scanner.getIncludedFiles()) {
            String className = ClassFileVisitorUtils.pathToClassName(path.replace(File.separatorChar, '/'));
            ClassFileVisitorUtils.acceptClassInDirectory(directory, path, className, visitorFactory.apply(className), handler);
        }
    }

    private static void acceptClassInDirectory(Path directory, String path, String className, ClassFileVisitor visitor, BiConsumer<String, IOException> handler) {
        Path classLocation = directory.resolve(path);
        try (InputStream in = Files.newInputStream(classLocation, new OpenOption[0]);){
            visitor.visitClass(className, in);
        }
        catch (IOException ioException) {
            handler.accept(path, ioException);
        }
    }

    private static String pathToClassName(String path) {
        return path.substring(0, path.length() - DOT_CLASS.length()).replace('/', '.');
    }

    @Generated
    private ClassFileVisitorUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

