/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.manifest.dependencies;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="manifest", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.INITIALIZE)
public class DependencyManifest
extends AbstractMojo {
    static final byte[] CRLF = "\r\n".getBytes(StandardCharsets.UTF_8);
    static final byte[] SPACE = " ".getBytes(StandardCharsets.UTF_8);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject mavenProject;
    @Parameter(property="manifest.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="manifest.output", defaultValue="${project.build.directory}/classpath.manifest")
    private File manifest;
    private CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
    private ByteBuffer out = ByteBuffer.allocate(72);

    public void execute() throws MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        Set artifacts = this.mavenProject.getArtifacts();
        if (artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"No dependencies");
            return;
        }
        try {
            this.writeManifest(this.buildManifest());
        }
        catch (IOException | OverConstrainedVersionException e) {
            throw new MojoFailureException(e.getMessage(), e);
        }
    }

    private Map<String, Artifact> buildManifest() throws OverConstrainedVersionException {
        TreeMap<String, Artifact> manifest = new TreeMap<String, Artifact>();
        Set artifacts = this.mavenProject.getArtifacts();
        for (Artifact artifact : artifacts) {
            manifest.put(artifact.getDependencyConflictId().toString(), artifact);
        }
        return manifest;
    }

    private void writeManifest(Map<String, Artifact> artifactMap) throws IOException, OverConstrainedVersionException {
        File dir = this.manifest.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Unable to create " + dir);
        }
        FileOutputStream fos = new FileOutputStream(this.manifest);
        FileChannel fileChannel = fos.getChannel();
        for (Map.Entry<String, Artifact> entry : artifactMap.entrySet()) {
            this.writePair(fileChannel, "");
            this.writePair(fileChannel, "Name: " + entry.getKey());
            Artifact artifact = entry.getValue();
            this.writePair(fileChannel, artifact.getScope() + ": " + artifact.getSelectedVersion());
        }
        fileChannel.close();
    }

    void writePair(FileChannel fileChannel, String name_value) throws IOException {
        CharBuffer in = CharBuffer.wrap(name_value);
        this.out.limit(70);
        CoderResult result = this.flush(fileChannel, in);
        while (result.isOverflow()) {
            this.out.limit(70);
            this.out.put(SPACE);
            result = this.flush(fileChannel, in);
        }
    }

    private CoderResult flush(FileChannel fileChannel, CharBuffer in) throws IOException {
        CoderResult result = this.encoder.encode(in, this.out, true);
        this.out.limit(72);
        this.out.put(CRLF);
        this.out.flip();
        fileChannel.write(this.out);
        this.out.rewind();
        return result;
    }
}

