/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.dogstatd.model;

import java.util.regex.Pattern;

public final class Validator {
    private static final Pattern VALID_NAME = Pattern.compile("^[A-Za-z][0-9A-Za-z_\\.]*$");
    private static final Pattern VALID_TAG = Pattern.compile("^[a-z][0-9a-z_\\-:\\./]{0,199}$");
    private static final Pattern NO_PIPES = Pattern.compile("^[^\\|\\p{Cntrl}]+$");

    private Validator() {
    }

    public static boolean nameIsValid(String name) {
        return VALID_NAME.matcher(name).matches();
    }

    public static boolean tagIsValid(String tag) {
        return VALID_TAG.matcher(tag).matches();
    }

    public static boolean fieldIsValid(String value) {
        return NO_PIPES.matcher(value).matches();
    }
}

