/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.dogstatd.model;

import java.nio.CharBuffer;
import java.util.Arrays;
import lombok.NonNull;
import org.honton.chas.dogstatd.model.Message;
import org.honton.chas.dogstatd.model.Tags;
import org.honton.chas.dogstatd.model.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Event
implements Message {
    private static final Logger log = LoggerFactory.getLogger(Event.class);
    private final String title;
    private final String text;
    private final String[] tags;
    private Long timestamp;
    private String host;
    private String key;
    private Priority priority;
    private String source;
    private Alert alert;

    Event(@NonNull String title, @NonNull String text, String ... tags) {
        if (title == null) {
            throw new NullPointerException("title");
        }
        if (text == null) {
            throw new NullPointerException("text");
        }
        this.title = title;
        this.text = text;
        this.tags = tags;
    }

    @Override
    public boolean validate() {
        if (this.title.isEmpty()) {
            log.warn("title should be non-empty");
            return false;
        }
        if (this.host != null && !Validator.fieldIsValid(this.host)) {
            log.warn("host contains control characters or is empty");
            return false;
        }
        if (this.key != null && !Validator.fieldIsValid(this.key)) {
            log.warn("key contains control characters or is empty");
            return false;
        }
        if (this.source != null && !Validator.fieldIsValid(this.source)) {
            log.warn("source contains control characters or is empty");
            return false;
        }
        return Tags.validate(log, this.tags);
    }

    @Override
    public void format(CharBuffer chars) {
        chars.append("_e{").append(Integer.toString(this.title.length())).append(',').append(Integer.toString(this.text.length())).append("}:").append(this.title).append('|').append(this.text);
        if (this.timestamp != null) {
            chars.append("|d:").append(this.timestamp.toString());
        }
        if (this.host != null) {
            chars.append("|h:").append(this.host);
        }
        if (this.key != null) {
            chars.append("|k:").append(this.key);
        }
        if (this.priority != null) {
            chars.append("|p:").append(this.priority.name());
        }
        if (this.source != null) {
            chars.append("|s:").append(this.source);
        }
        if (this.alert != null) {
            chars.append("|t:").append(this.alert.name());
        }
        Tags.format(chars, this.tags);
        chars.append('\n');
    }

    public Event setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Event setHost(String host) {
        this.host = host;
        return this;
    }

    public Event setKey(String key) {
        this.key = key;
        return this;
    }

    public Event setPriority(Priority priority) {
        this.priority = priority;
        return this;
    }

    public Event setSource(String source) {
        this.source = source;
        return this;
    }

    public Event setAlert(Alert alert) {
        this.alert = alert;
        return this;
    }

    public String toString() {
        return "Event(title=" + this.title + ", text=" + this.text + ", tags=" + Arrays.deepToString(this.tags) + ", timestamp=" + this.timestamp + ", host=" + this.host + ", key=" + this.key + ", priority=" + (Object)((Object)this.priority) + ", source=" + this.source + ", alert=" + (Object)((Object)this.alert) + ")";
    }

    public static enum Alert {
        success,
        info,
        warning,
        error;

    }

    public static enum Priority {
        normal,
        low;

    }
}

