/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.dogstatd.model;

import java.nio.CharBuffer;
import java.util.Arrays;
import lombok.NonNull;
import org.honton.chas.dogstatd.model.Message;
import org.honton.chas.dogstatd.model.Tags;
import org.honton.chas.dogstatd.model.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCheck
implements Message {
    private static final Logger log = LoggerFactory.getLogger(ServiceCheck.class);
    private final String name;
    private final Status value;
    private final String[] tags;
    private Long timestamp;
    private String host;
    private String message;

    ServiceCheck(@NonNull String name, @NonNull Status value, String ... tags) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.name = name;
        this.value = value;
        this.tags = tags;
    }

    @Override
    public boolean validate() {
        if (!Validator.nameIsValid(this.name)) {
            log.warn("invalid name '{}'", (Object)this.name);
            return false;
        }
        if (this.host != null && !Validator.fieldIsValid(this.host)) {
            log.warn("host contains control characters or is empty");
            return false;
        }
        return Tags.validate(log, this.tags);
    }

    @Override
    public void format(CharBuffer chars) {
        chars.append("_sc|").append(this.name).append('|').append(Integer.toString(this.value.ordinal()));
        if (this.timestamp != null) {
            chars.append("|d:").append(this.timestamp.toString());
        }
        if (this.host != null) {
            chars.append("|h:").append(this.host);
        }
        Tags.format(chars, this.tags);
        if (this.message != null) {
            chars.append("|m:").append(this.message);
        }
        chars.append('\n');
    }

    public String toString() {
        return "ServiceCheck(name=" + this.name + ", value=" + (Object)((Object)this.value) + ", tags=" + Arrays.deepToString(this.tags) + ", timestamp=" + this.timestamp + ", host=" + this.host + ", message=" + this.message + ")";
    }

    public ServiceCheck setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public ServiceCheck setHost(String host) {
        this.host = host;
        return this;
    }

    public ServiceCheck setMessage(String message) {
        this.message = message;
        return this;
    }

    public static enum Status {
        OK,
        WARNING,
        CRITICAL,
        UNKNOWN;

    }
}

