/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.dogstatd.model;

import java.nio.CharBuffer;
import java.util.Arrays;
import lombok.NonNull;
import org.honton.chas.dogstatd.model.Message;
import org.honton.chas.dogstatd.model.Tags;
import org.honton.chas.dogstatd.model.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Metric<T>
implements Message {
    private static final Logger log = LoggerFactory.getLogger(Metric.class);
    private final String name;
    protected final T value;
    private final char type;
    private final String[] tags;

    Metric(@NonNull String name, @NonNull T value, char type, String ... tags) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.name = name;
        this.value = value;
        this.type = type;
        this.tags = tags;
    }

    @Override
    public boolean validate() {
        if (!Validator.nameIsValid(this.name)) {
            log.warn("invalid name '{}'", (Object)this.name);
            return false;
        }
        return Tags.validate(log, this.tags);
    }

    @Override
    public void format(CharBuffer chars) {
        chars.append(this.name).append(':').append(this.value.toString()).append('|').append(this.type);
        Tags.format(chars, this.tags);
        chars.append('\n');
    }

    public String toString() {
        return "Metric(name=" + this.name + ", value=" + this.value + ", type=" + this.type + ", tags=" + Arrays.deepToString(this.tags) + ")";
    }
}

