/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.exists;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.honton.chas.exists.CheckSum;

public abstract class AbstractExistsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${project.groupId}:${project.artifactId}:${project.version}")
    private String project;
    @Parameter(defaultValue="${project.build.finalName}.${project.packaging}")
    private String artifact;
    @Parameter(defaultValue="${createChecksum}")
    private boolean useChecksum;
    @Parameter(defaultValue="true")
    private boolean skipIfSnapshot;
    private static final Pattern GAV_PARSER = Pattern.compile("^([^:]*):([^:]*):([^:]*)$");

    protected abstract InputStream getRemoteArtifactStream(String var1) throws IOException;

    protected abstract String getRepositoryBase() throws MojoExecutionException;

    protected abstract String getPropertyName();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Boolean matches;
            Boolean bl = matches = this.useChecksum ? this.verifyWithChecksum() : this.verifyWithExistence();
            if (matches != null) {
                String propertyName = this.getPropertyName();
                String value = Boolean.toString(matches);
                this.getLog().info((CharSequence)("setting " + propertyName + "=" + value));
                this.mavenProject.getProperties().setProperty(propertyName, value);
            }
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private Boolean verifyWithExistence() throws IOException, MojoExecutionException {
        if (this.skipIfSnapshot && this.isSnapshot()) {
            this.getLog().debug((CharSequence)"skipping -SNAPSHOT");
            return null;
        }
        String uri = this.getRepositoryUri();
        this.getLog().debug((CharSequence)("checking for resource at " + uri));
        return this.checkArtifactExists(uri);
    }

    protected boolean isSnapshot() {
        return this.project.endsWith("-SNAPSHOT");
    }

    protected abstract Boolean checkArtifactExists(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean verifyWithChecksum() throws IOException, MojoFailureException, NoSuchAlgorithmException, MojoExecutionException {
        String uri = this.getRepositoryUri();
        this.getLog().debug((CharSequence)("checking for resource " + uri));
        InputStream inputStream = this.getRemoteArtifactStream(uri + ".sha1");
        if (inputStream == null) {
            return null;
        }
        try {
            String priorChecksum = IOUtil.toString((InputStream)inputStream, (String)"ISO_8859_1", (int)1000);
            String buildChecksum = this.getArtifactChecksum();
            if (priorChecksum.equalsIgnoreCase(buildChecksum)) {
                Boolean bl = true;
                return bl;
            }
            this.getLog().debug((CharSequence)("buildChecksum(" + buildChecksum + ") != priorChecksum(" + priorChecksum + ")"));
            Boolean bl = false;
            return bl;
        }
        finally {
            IOUtil.close((InputStream)inputStream);
        }
    }

    private String getRepositoryUri() throws MojoExecutionException {
        Matcher matcher = GAV_PARSER.matcher(this.project);
        if (!matcher.matches()) {
            return this.getRepositoryBase() + '/' + this.project + '/' + this.artifact;
        }
        String groupId = matcher.group(1);
        String artifactId = matcher.group(2);
        String version = matcher.group(3);
        return this.getRepositoryBase() + '/' + groupId.replace('.', '/') + '/' + artifactId.replace('.', '/') + '/' + version + '/' + this.artifact;
    }

    private String getArtifactChecksum() throws IOException, MojoFailureException, NoSuchAlgorithmException {
        CheckSum signer = new CheckSum("SHA-1");
        Artifact mavenArtifact = this.mavenProject.getArtifact();
        File file = "pom".equals(mavenArtifact.getType()) ? new File(this.mavenProject.getBasedir(), "pom.xml") : new File(this.mavenProject.getBuild().getDirectory(), this.artifact);
        if (file != null && file.isFile()) {
            this.getLog().debug((CharSequence)("Calculating checksum for " + file));
            return signer.getChecksum(file);
        }
        throw new MojoFailureException("The project artifact " + file + " has not been created.");
    }
}

