/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.exists;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="exists", defaultPhase=LifecyclePhase.INITIALIZE)
public class ArtifactExistsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject maven;
    @Parameter(defaultValue="${project.distributionManagement.repository.url}")
    private String repository;
    @Parameter(defaultValue="${project.groupId}:${project.artifactId}:${project.version}")
    private String project;
    @Parameter(defaultValue="${project.artifactId}-${project.version}.pom")
    private String artifact;
    @Parameter(defaultValue="maven.deploy.skip")
    private String property;
    @Parameter(defaultValue="true")
    private boolean skipIfSnapshot;
    private final Pattern GAV_PARSER = Pattern.compile("^([^:]*):([^:]*):([^:]*)$");

    public void execute() throws MojoExecutionException {
        try {
            this.doWork();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void doWork() throws IOException {
        if (this.skipIfSnapshot && this.project.endsWith("-SNAPSHOT")) {
            this.getLog().debug((CharSequence)"skipping -SNAPSHOT");
            return;
        }
        String uri = this.getFetchUri();
        this.getLog().debug((CharSequence)("checking for resource at " + uri));
        HttpURLConnection con = (HttpURLConnection)new URL(uri).openConnection();
        con.setRequestMethod("HEAD");
        boolean exists = con.getResponseCode() == 200;
        this.getLog().debug((CharSequence)(uri + (exists ? " exists" : " does not exist")));
        this.maven.getProperties().setProperty(this.property, Boolean.toString(exists));
    }

    public String getFetchUri() {
        Matcher matcher = this.GAV_PARSER.matcher(this.project);
        if (!matcher.matches()) {
            return this.repository + '/' + this.project + '/' + this.artifact;
        }
        String groupId = matcher.group(1);
        String artifactId = matcher.group(2);
        String version = matcher.group(3);
        return this.repository + '/' + groupId.replace('.', '/') + '/' + artifactId.replace('.', '/') + '/' + version + '/' + this.artifact;
    }
}

