/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.exists;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.exists.AbstractExistsMojo;

@Mojo(name="remote", defaultPhase=LifecyclePhase.VERIFY)
public class RemoteExistsMojo
extends AbstractExistsMojo {
    @Parameter(defaultValue="maven.deploy.skip")
    private String property;
    @Parameter(defaultValue="${project.distributionManagement.repository.url}")
    private String repository;
    @Parameter(defaultValue="${project.distributionManagement.snapshotRepository.url}")
    private String snapshotRepository;

    @Override
    protected String getPropertyName() {
        return this.property;
    }

    @Override
    protected String getRepositoryBase() throws MojoExecutionException {
        if (this.isSnapshot()) {
            if (this.snapshotRepository == null) {
                throw new MojoExecutionException("distributionManagement snapshotRepository is not set");
            }
            return this.snapshotRepository;
        }
        if (this.repository == null) {
            throw new MojoExecutionException("distributionManagement repository is not set");
        }
        return this.repository;
    }

    @Override
    protected Boolean checkArtifactExists(String uri) throws IOException {
        URLConnection urlConnection = new URL(uri).openConnection();
        HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
        httpURLConnection.setRequestMethod("HEAD");
        return httpURLConnection.getResponseCode() == 200;
    }

    @Override
    protected InputStream getRemoteArtifactStream(String uri) throws IOException {
        HttpURLConnection con = (HttpURLConnection)new URL(uri).openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("Accept", "text/plain");
        con.connect();
        if (con.getResponseCode() != 200) {
            this.getLog().debug((CharSequence)("GET of " + uri + " returned status " + con.getResponseCode()));
            return null;
        }
        return con.getInputStream();
    }
}

