/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.exists;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.exists.AbstractExistsMojo;

@Mojo(name="local", defaultPhase=LifecyclePhase.VERIFY)
public class LocalExistsMojo
extends AbstractExistsMojo {
    @Parameter(defaultValue="maven.install.skip")
    private String property;
    @Parameter(property="localRepository", required=true, readonly=true)
    protected ArtifactRepository localRepository;

    @Override
    protected String getPropertyName() {
        return this.property;
    }

    @Override
    protected String getRepositoryBase() {
        return this.localRepository.getBasedir();
    }

    @Override
    protected Boolean checkArtifactExists(String uri) throws IOException {
        return new File(uri).isFile();
    }

    @Override
    protected byte[] getRemoteChecksum(String uri) throws MojoExecutionException, IOException {
        File file = new File(uri);
        if (!file.isFile()) {
            return null;
        }
        return Files.readAllBytes(file.toPath());
    }
}

