/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.exists;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.StreamingWagon;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.honton.chas.exists.AbstractExistsMojo;

@Mojo(name="remote", defaultPhase=LifecyclePhase.VERIFY)
public class RemoteExistsMojo
extends AbstractExistsMojo {
    @Parameter(defaultValue="maven.deploy.skip")
    private String property;
    @Parameter(defaultValue="${project.distributionManagement.repository.url}")
    private String repository;
    @Parameter(defaultValue="${project.distributionManagement.snapshotRepository.url}")
    private String snapshotRepository;
    @Parameter(defaultValue="${project.distributionManagement.repository.id}")
    private String serverId;
    @Parameter(defaultValue="${project.distributionManagement.snapshotRepository.id}")
    private String snapshotServerId;
    @Parameter(defaultValue="${settings}", required=true, readonly=true)
    private Settings settings;
    @Component
    private WagonManager wagonManager;

    @Override
    protected String getPropertyName() {
        return this.property;
    }

    @Override
    protected String getRepositoryBase() throws MojoExecutionException {
        if (this.isSnapshot()) {
            if (this.snapshotRepository == null) {
                throw new MojoExecutionException("distributionManagement snapshotRepository is not set");
            }
            return this.snapshotRepository;
        }
        if (this.repository == null) {
            throw new MojoExecutionException("distributionManagement repository is not set");
        }
        return this.repository;
    }

    @Override
    protected Boolean checkArtifactExists(String uri) throws IOException, MojoExecutionException {
        String path = this.getPath(uri);
        try (WagonHelper wagonHelper = new WagonHelper(this.getRepositoryBase());){
            Boolean bl = wagonHelper.resourceExists(path);
            return bl;
        }
    }

    @Override
    protected byte[] getRemoteChecksum(String uri) throws MojoExecutionException {
        try (WagonHelper wagonHelper = new WagonHelper(this.getRepositoryBase());){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            wagonHelper.get(this.getPath(uri), baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private String getPath(String uri) throws MojoExecutionException {
        String repositoryBase = this.getRepositoryBase();
        if (!uri.startsWith(repositoryBase + "/")) {
            throw new IllegalArgumentException("Invalid URL: " + uri);
        }
        return uri.substring(repositoryBase.length() + 1);
    }

    private class WagonHelper
    implements AutoCloseable {
        private final String uri;
        private final Wagon wagon;

        WagonHelper(String uri) throws MojoExecutionException {
            this.uri = uri;
            try {
                String id = RemoteExistsMojo.this.isSnapshot() ? RemoteExistsMojo.this.snapshotServerId : RemoteExistsMojo.this.serverId;
                this.wagon = this.createWagon(id == null ? "" : id, uri);
            }
            catch (WagonException e) {
                throw new MojoExecutionException("Could not create Wagon for " + uri, (Exception)((Object)e));
            }
        }

        Wagon createWagon(String serverId, String url) throws WagonException {
            ProxyInfo proxyInfo;
            Repository repository = new Repository(serverId, url);
            Wagon wagon = RemoteExistsMojo.this.wagonManager.getWagon(repository);
            if (RemoteExistsMojo.this.getLog().isDebugEnabled()) {
                Debug debug = new Debug();
                wagon.addSessionListener((SessionListener)debug);
                wagon.addTransferListener((TransferListener)debug);
            }
            if ((proxyInfo = this.getProxyInfo()) != null) {
                wagon.connect(repository, RemoteExistsMojo.this.wagonManager.getAuthenticationInfo(repository.getId()), proxyInfo);
            } else {
                wagon.connect(repository, RemoteExistsMojo.this.wagonManager.getAuthenticationInfo(repository.getId()));
            }
            return wagon;
        }

        ProxyInfo getProxyInfo() {
            if (RemoteExistsMojo.this.settings.getActiveProxy() == null) {
                return null;
            }
            ProxyInfo proxyInfo = new ProxyInfo();
            Proxy proxy = RemoteExistsMojo.this.settings.getActiveProxy();
            proxyInfo.setHost(proxy.getHost());
            proxyInfo.setType(proxy.getProtocol());
            proxyInfo.setPort(proxy.getPort());
            proxyInfo.setNonProxyHosts(proxy.getNonProxyHosts());
            proxyInfo.setUserName(proxy.getUsername());
            proxyInfo.setPassword(proxy.getPassword());
            return proxyInfo;
        }

        boolean resourceExists(String resourceName) throws MojoExecutionException {
            try {
                return this.wagon.resourceExists(resourceName);
            }
            catch (WagonException e) {
                throw new MojoExecutionException("Checking remote resource failed for " + this.uri, (Exception)((Object)e));
            }
        }

        void get(String resourceName, OutputStream outputStream) throws MojoExecutionException {
            try {
                ((StreamingWagon)this.wagon).getToStream(resourceName, outputStream);
            }
            catch (WagonException e) {
                throw new MojoExecutionException("Fetching remote checksum failed for " + this.uri, (Exception)((Object)e));
            }
        }

        @Override
        public void close() {
            try {
                this.wagon.disconnect();
            }
            catch (ConnectionException e) {
                RemoteExistsMojo.this.getLog().debug((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
            }
        }
    }
}

