/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.exists;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.honton.chas.exists.CheckSum;

public abstract class AbstractExistsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${project.groupId}:${project.artifactId}:${project.version}")
    private String project;
    @Parameter(defaultValue="${project.build.finalName}.${project.packaging}")
    private String artifact;
    @Parameter(defaultValue="${createChecksum}")
    private boolean useChecksum;
    @Parameter(defaultValue="true")
    private boolean skipIfSnapshot;
    @Parameter(defaultValue="false")
    private boolean userProperty;
    @Parameter(defaultValue="${failIfExists}")
    private boolean failIfExists;
    @Parameter(defaultValue="${failIfNotExists}")
    private boolean failIfNotExists;
    @Parameter(defaultValue="false", property="exists.skip")
    private boolean skip;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    private static final Pattern GAV_PARSER = Pattern.compile("^([^:]*):([^:]*):([^:]*)$");

    protected abstract byte[] getRemoteChecksum(String var1) throws MojoExecutionException, IOException;

    protected abstract String getRepositoryBase() throws MojoExecutionException;

    protected abstract String getPropertyName();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping exists execution");
            return;
        }
        try {
            Boolean matches;
            Boolean bl = matches = this.useChecksum ? this.verifyWithChecksum() : this.verifyWithExistence();
            if (matches != null) {
                if (this.failIfExists && matches.booleanValue()) {
                    throw new MojoFailureException("Artifact already exists in repository: " + this.project + "/" + this.artifact);
                }
                if (this.failIfNotExists && !matches.booleanValue()) {
                    throw new MojoFailureException("Artifact does not exist in repository: " + this.project + "/" + this.artifact);
                }
                String propertyName = this.getPropertyName();
                String value = Boolean.toString(matches);
                if (this.userProperty) {
                    this.getLog().info((CharSequence)("setting user property " + propertyName + "=" + value));
                    this.session.getUserProperties().setProperty(propertyName, value);
                } else {
                    this.getLog().info((CharSequence)("setting " + propertyName + "=" + value));
                    this.mavenProject.getProperties().setProperty(propertyName, value);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private Boolean verifyWithExistence() throws IOException, MojoExecutionException {
        if (this.skipIfSnapshot && this.isSnapshot()) {
            this.getLog().debug((CharSequence)"skipping -SNAPSHOT");
            return null;
        }
        String uri = this.getRepositoryUri();
        this.getLog().debug((CharSequence)("checking for resource at " + uri));
        return this.checkArtifactExists(uri);
    }

    protected boolean isSnapshot() {
        return this.project.endsWith("-SNAPSHOT");
    }

    protected abstract Boolean checkArtifactExists(String var1) throws IOException, MojoExecutionException;

    private Boolean verifyWithChecksum() throws IOException, MojoFailureException, NoSuchAlgorithmException, MojoExecutionException {
        String uri = this.getRepositoryUri();
        this.getLog().debug((CharSequence)("checking for resource " + uri));
        String priorChecksum = this.getPriorChecksum(uri);
        String buildChecksum = this.getArtifactChecksum();
        if (buildChecksum.equalsIgnoreCase(priorChecksum)) {
            return Boolean.TRUE;
        }
        this.getLog().debug((CharSequence)("buildChecksum(" + buildChecksum + ") != priorChecksum(" + priorChecksum + ")"));
        return Boolean.FALSE;
    }

    private String getPriorChecksum(String uri) throws IOException {
        try {
            byte[] priorChecksumBytes = this.getRemoteChecksum(uri + ".sha1");
            return new String(priorChecksumBytes, StandardCharsets.ISO_8859_1);
        }
        catch (MojoExecutionException ex) {
            this.getLog().debug((CharSequence)("Unable to get prior checksum. Reason:" + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    private String getRepositoryUri() throws MojoExecutionException {
        Matcher matcher = GAV_PARSER.matcher(this.project);
        if (!matcher.matches()) {
            return this.getRepositoryBase() + '/' + this.project + '/' + this.artifact;
        }
        String groupId = matcher.group(1);
        String artifactId = matcher.group(2);
        String version = matcher.group(3);
        return this.getRepositoryBase() + '/' + groupId.replace('.', '/') + '/' + artifactId + '/' + version + '/' + this.artifact;
    }

    private String getArtifactChecksum() throws IOException, MojoFailureException, NoSuchAlgorithmException {
        CheckSum signer = new CheckSum("SHA-1");
        Artifact mavenArtifact = this.mavenProject.getArtifact();
        File file = "pom".equals(mavenArtifact.getType()) ? new File(this.mavenProject.getBasedir(), "pom.xml") : new File(this.mavenProject.getBuild().getDirectory(), this.artifact);
        if (file.isFile()) {
            this.getLog().debug((CharSequence)("Calculating checksum for " + file));
            return signer.getChecksum(file);
        }
        throw new MojoFailureException("The project artifact " + file + " has not been created.");
    }
}

