/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.exists;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoFailureException;

public class GAV {
    private static final Pattern GAV_PARSER = Pattern.compile("^([^:]+):([^:]+):([^:]+:)?([^:]+)$");
    final String groupId;
    final String artifactId;
    final String type;
    final String classifier;
    final String version;

    GAV(String project, String packaging, String configuredClassifier) throws MojoFailureException {
        Matcher matcher = GAV_PARSER.matcher(project);
        if (!matcher.matches()) {
            throw new MojoFailureException("Project property must be in format groupId:artifactId:[type:]version");
        }
        this.groupId = matcher.group(1);
        this.artifactId = matcher.group(2);
        String optional = matcher.group(3);
        this.type = optional != null ? optional.substring(0, optional.length() - 1) : packaging;
        this.classifier = configuredClassifier;
        this.version = matcher.group(4);
    }

    GAV(String project, String packaging) throws MojoFailureException {
        this(project, packaging, null);
    }

    String artifactLocation() {
        return this.artifactDirectory() + this.artifactFile(this.version);
    }

    String snapshotLocation(String buildVersion) {
        return this.artifactDirectory() + this.artifactFile(buildVersion);
    }

    String artifactDirectory() {
        return "/" + this.groupId.replace('.', '/') + "/" + this.artifactId + "/" + this.version + "/";
    }

    private String artifactFile(String version) {
        return this.artifactId + "-" + version + (String)(this.classifier != null ? "-" + this.classifier : "") + "." + this.extension();
    }

    private String extension() {
        switch (this.type) {
            case "ejb": 
            case "java-doc": 
            case "maven-plugin": {
                return "jar";
            }
        }
        return this.type;
    }
}

