/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.exists;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.exists.AbstractExistsMojo;
import org.honton.chas.exists.CheckSum;

@Mojo(name="local", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class LocalExistsMojo
extends AbstractExistsMojo {
    @Parameter(property="localRepository", required=true, readonly=true)
    protected ArtifactRepository localRepository;
    @Parameter(property="exists.property", defaultValue="maven.install.skip")
    private String property;

    @Override
    protected String getPropertyName() {
        return this.property;
    }

    @Override
    protected String getVersionedPath(SnapshotVersion version) {
        return this.gav.artifactLocation();
    }

    @Override
    protected String getMavenMetadata(String directory) throws Exception {
        Path path = LocalExistsMojo.getPath(this.localRepository.getBasedir(), directory, "maven-metadata-local.xml");
        this.getLog().debug((CharSequence)("Reading metadata from " + String.valueOf(path)));
        return Files.readString(path, StandardCharsets.ISO_8859_1);
    }

    @Override
    protected boolean checkArtifactExists(String file) {
        Path path = LocalExistsMojo.getPath(this.localRepository.getBasedir(), file);
        this.getLog().info((CharSequence)("Checking for artifact at " + String.valueOf(path)));
        return Files.isReadable(path);
    }

    @Override
    protected String getArtifactChecksum(String file) throws IOException, GeneralSecurityException {
        Path path = LocalExistsMojo.getPath(this.localRepository.getBasedir(), file);
        this.getLog().debug((CharSequence)("checking for resource " + String.valueOf(path)));
        return new CheckSum().getChecksum(path);
    }
}

