/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.exists;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoFailureException;

public class GAV {
    private static final Pattern GAV_PARSER = Pattern.compile("^([^:]+):([^:]+):(([^:]+):)?([^:]+)$");
    final String groupId;
    final String artifactId;
    final String classifier;
    final String version;
    final String extension;

    GAV(String project, String packaging, String configuredClassifier, Map<String, String> packageExtensions) throws MojoFailureException {
        Matcher matcher = GAV_PARSER.matcher(project);
        if (!matcher.matches()) {
            throw new MojoFailureException("Project property must be in format groupId:artifactId:[packaging:]version");
        }
        this.groupId = matcher.group(1);
        this.artifactId = matcher.group(2);
        String optional = matcher.group(4);
        this.version = matcher.group(5);
        String packagingType = packaging != null ? packaging : "jar";
        this.classifier = configuredClassifier != null ? configuredClassifier : GAV.classifier(packagingType);
        this.extension = GAV.extension(packageExtensions, optional != null ? optional : packagingType);
    }

    private static String classifier(String packagingType) {
        return switch (packagingType) {
            case "test-jar" -> "tests";
            case "ejb-client" -> "client";
            case "java-source", "javadoc" -> "sources";
            default -> null;
        };
    }

    private static String extension(Map<String, String> packageExtensions, String packagingType) {
        return switch (packagingType) {
            case "pom", "war", "ear", "rar" -> packagingType;
            case "jar", "test-jar", "maven-plugin", "ejb", "ejb-client", "java-source", "javadoc" -> "jar";
            default -> packageExtensions != null ? packageExtensions.getOrDefault(packagingType, packagingType) : packagingType;
        };
    }

    String artifactLocation() {
        return this.artifactDirectory() + this.artifactFile(this.version);
    }

    String snapshotLocation(String buildVersion) {
        return this.artifactDirectory() + this.artifactFile(buildVersion);
    }

    String artifactDirectory() {
        return this.groupId.replace('.', '/') + "/" + this.artifactId + "/" + this.version + "/";
    }

    private String artifactFile(String version) {
        return this.artifactId + "-" + version + (String)(this.classifier != null ? "-" + this.classifier : "") + "." + this.extension;
    }
}

