/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.exists;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.honton.chas.exists.CheckSum;

public abstract class AbstractExistsMojo
extends AbstractMojo {
    private static final Pattern GAV_PARSER = Pattern.compile("^([^:]*):([^:]*):([^:]*)$");
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(property="exists.project", defaultValue="${project.groupId}:${project.artifactId}:${project.version}")
    private String project;
    @Parameter(property="exists.artifact", defaultValue="${project.build.finalName}.${project.packaging}")
    private String artifact;
    @Parameter(property="exists.cmpChecksum", defaultValue="false")
    private boolean cmpChecksum;
    @Parameter(property="exists.skipIfSnapshot", defaultValue="true")
    private boolean skipIfSnapshot;
    @Parameter(property="exists.userProperty", defaultValue="false")
    private boolean userProperty;
    @Parameter(property="exists.failIfExists", defaultValue="false")
    private boolean failIfExists;
    @Parameter(property="exists.failIfNotExists", defaultValue="false")
    private boolean failIfNotExists;
    @Parameter(property="exists.failIfNotMatch", defaultValue="true")
    private boolean failIfNotMatch;
    @Parameter(property="exists.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="exists.requireGoal")
    private String requireGoal;

    protected abstract String getRemoteChecksum(String var1) throws Exception;

    protected abstract String getRepositoryBase() throws MojoExecutionException;

    protected abstract String getPropertyName();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping exists execution");
            return;
        }
        if (this.requireGoal != null && !this.session.getGoals().contains(this.requireGoal)) {
            this.getLog().info((CharSequence)(this.requireGoal + " is not present in " + this.session.getGoals() + ", skipping execution"));
            return;
        }
        try {
            if (this.skipIfSnapshot && this.isSnapshot()) {
                this.getLog().debug((CharSequence)"skipping -SNAPSHOT");
                return;
            }
            String uri = this.getRepositoryUri();
            if (!this.artifactExists(uri)) {
                return;
            }
            if (this.cmpChecksum && !this.checksumMatches(uri)) {
                return;
            }
            String propertyName = this.getPropertyName();
            if (this.userProperty) {
                this.getLog().info((CharSequence)("setting user property " + propertyName + "=true"));
                this.session.getUserProperties().setProperty(propertyName, "true");
            } else {
                this.getLog().info((CharSequence)("setting " + propertyName + "=true"));
                this.mavenProject.getProperties().setProperty(propertyName, "true");
            }
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private boolean artifactExists(String uri) throws Exception {
        this.getLog().debug((CharSequence)("Checking for artifact at " + uri));
        boolean exists = this.checkArtifactExists(uri);
        if (exists) {
            if (this.failIfExists) {
                throw new MojoFailureException("Artifact already exists in repository: " + this.project + "/" + this.artifact);
            }
        } else {
            this.getLog().info((CharSequence)(this.project + " does not exist"));
            if (this.failIfNotExists) {
                throw new MojoFailureException("Artifact does not exist in repository: " + this.project + "/" + this.artifact);
            }
        }
        return exists;
    }

    protected boolean isSnapshot() {
        return this.project.endsWith("-SNAPSHOT");
    }

    protected abstract boolean checkArtifactExists(String var1) throws Exception;

    private boolean checksumMatches(String uri) throws Exception {
        this.getLog().debug((CharSequence)("checking for resource " + uri));
        String prior = this.getPriorChecksum(uri);
        String build = this.getArtifactChecksum();
        boolean matches = build.equalsIgnoreCase(prior);
        if (!matches) {
            this.getLog().info((CharSequence)(this.project + " checksum does not match"));
            if (this.failIfNotMatch) {
                String msg = "buildChecksum(" + build + ") != priorChecksum(" + prior + ")";
                throw new MojoFailureException(msg);
            }
        }
        return matches;
    }

    private String getPriorChecksum(String uri) throws Exception {
        return this.getRemoteChecksum(uri);
    }

    private String getRepositoryUri() throws Exception {
        Matcher matcher = GAV_PARSER.matcher(this.project);
        if (!matcher.matches()) {
            throw new MojoFailureException("Project property must be in format groupId:artifactId:version");
        }
        String groupId = matcher.group(1);
        String artifactId = matcher.group(2);
        String version = matcher.group(3);
        return this.getRepositoryBase() + '/' + groupId.replace('.', '/') + '/' + artifactId + '/' + version + '/' + this.artifact;
    }

    private String getArtifactChecksum() throws Exception {
        CheckSum signer = new CheckSum("SHA-1");
        Artifact mavenArtifact = this.mavenProject.getArtifact();
        File file = "pom".equals(mavenArtifact.getType()) ? new File(this.mavenProject.getBasedir(), "pom.xml") : new File(this.mavenProject.getBuild().getDirectory(), this.artifact);
        if (file.isFile()) {
            this.getLog().debug((CharSequence)("Calculating checksum for " + file));
            return signer.getChecksum(file);
        }
        throw new MojoFailureException("The project artifact " + file + " has not been created.");
    }
}

