/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.exists;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.exists.AbstractExistsMojo;
import org.honton.chas.exists.CheckSum;

@Mojo(name="local", defaultPhase=LifecyclePhase.VERIFY)
public class LocalExistsMojo
extends AbstractExistsMojo {
    @Parameter(property="exists.property", defaultValue="maven.install.skip")
    private String property;
    @Parameter(property="localRepository", required=true, readonly=true)
    protected ArtifactRepository localRepository;

    @Override
    protected String getPropertyName() {
        return this.property;
    }

    @Override
    protected String getRepositoryBase() {
        return this.localRepository.getBasedir();
    }

    @Override
    protected boolean checkArtifactExists(String uri) {
        return new File(uri).isFile();
    }

    @Override
    protected String getRemoteChecksum(String uri) throws IOException, GeneralSecurityException {
        File file = new File(uri + ".sha1");
        if (file.isFile()) {
            return new String(Files.readAllBytes(file.toPath()), StandardCharsets.ISO_8859_1);
        }
        return new CheckSum("SHA-1").getChecksum(new File(uri));
    }
}

