/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.exists;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.configuration.BeanConfigurationException;
import org.apache.maven.configuration.BeanConfigurationRequest;
import org.apache.maven.configuration.BeanConfigurator;
import org.apache.maven.configuration.DefaultBeanConfigurationRequest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.StreamingWagon;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.honton.chas.exists.AbstractExistsMojo;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

@Mojo(name="remote", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class RemoteExistsMojo
extends AbstractExistsMojo
implements Contextualizable {
    @Parameter(property="exists.property", defaultValue="maven.deploy.skip")
    private String property;
    @Parameter(property="exists.repository", defaultValue="${project.distributionManagement.repository.url}")
    private String repository;
    @Parameter(property="exists.snapshotRepository", defaultValue="${project.distributionManagement.snapshotRepository.url}")
    private String snapshotRepository;
    @Parameter(property="exists.serverId", defaultValue="${project.distributionManagement.repository.id}")
    private String serverId;
    @Parameter(property="exists.snapshotServerId", defaultValue="${project.distributionManagement.snapshotRepository.id}")
    private String snapshotServerId;
    @Parameter(defaultValue="${settings}", required=true, readonly=true)
    private Settings settings;
    @Component(role=SecDispatcher.class, hint="default")
    private SecDispatcher securityDispatcher;
    @Component(role=BeanConfigurator.class, hint="default")
    private BeanConfigurator beanConfigurator;
    private PlexusContainer container;

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    @Override
    protected String getPropertyName() {
        return this.property;
    }

    @Override
    protected String getVersionedPath(SnapshotVersion version) {
        return this.gav.snapshotLocation(version.getVersion());
    }

    @Override
    protected String getMavenMetadata(String path) throws Exception {
        return this.getRemoteFile(path + "maven-metadata.xml");
    }

    private String getRepositoryBase() throws MojoExecutionException {
        if (this.isSnapshot()) {
            if (this.snapshotRepository == null) {
                throw new MojoExecutionException("distributionManagement snapshotRepository is not set");
            }
            return this.snapshotRepository;
        }
        if (this.repository == null) {
            throw new MojoExecutionException("distributionManagement repository is not set");
        }
        return this.repository;
    }

    @Override
    protected boolean checkArtifactExists(String path) throws Exception {
        String repositoryBase = this.getRepositoryBase();
        this.getLog().info((CharSequence)("Checking for artifact at " + repositoryBase + path));
        try (WagonHelper wagonHelper = new WagonHelper(repositoryBase);){
            boolean bl = wagonHelper.resourceExists(path);
            return bl;
        }
    }

    @Override
    protected String getArtifactChecksum(String path) throws Exception {
        return this.getRemoteFile(path + ".sha1");
    }

    private String getRemoteFile(String path) throws Exception {
        String repositoryBase = this.getRepositoryBase();
        this.getLog().debug((CharSequence)("Fetching " + repositoryBase + path));
        try (WagonHelper wagonHelper = new WagonHelper(repositoryBase);){
            String string = wagonHelper.getContent(path);
            return string;
        }
    }

    private class WagonHelper
    implements AutoCloseable {
        private final Wagon wagon;

        WagonHelper(String uri) throws Exception {
            String id = RemoteExistsMojo.this.isSnapshot() ? RemoteExistsMojo.this.snapshotServerId : RemoteExistsMojo.this.serverId;
            this.wagon = this.connectWagon(id == null ? "" : id, uri);
        }

        Wagon connectWagon(String serverId, String url) throws Exception {
            Repository repo = new Repository(serverId, url);
            Wagon wgn = (Wagon)RemoteExistsMojo.this.container.lookup(Wagon.class, repo.getProtocol());
            this.configureWagon(wgn);
            wgn.connect(repo, this.getAuthInfo(serverId), this.getProxyInfo());
            return wgn;
        }

        void configureWagon(Wagon wagon) throws BeanConfigurationException {
            Server server = RemoteExistsMojo.this.settings.getServer(RemoteExistsMojo.this.serverId);
            if (server == null) {
                RemoteExistsMojo.this.getLog().debug((CharSequence)("no server for id " + RemoteExistsMojo.this.serverId));
                return;
            }
            Object serverConfiguration = server.getConfiguration();
            if (serverConfiguration == null) {
                RemoteExistsMojo.this.getLog().debug((CharSequence)"no server configuration");
                return;
            }
            DefaultBeanConfigurationRequest bcr = new DefaultBeanConfigurationRequest();
            bcr.setBean((Object)wagon);
            bcr.setConfiguration(serverConfiguration);
            RemoteExistsMojo.this.beanConfigurator.configureBean((BeanConfigurationRequest)bcr);
        }

        ProxyInfo getProxyInfo() {
            Proxy proxy = RemoteExistsMojo.this.settings.getActiveProxy();
            if (proxy == null) {
                return null;
            }
            ProxyInfo proxyInfo = new ProxyInfo();
            proxyInfo.setHost(proxy.getHost());
            proxyInfo.setType(proxy.getProtocol());
            proxyInfo.setPort(proxy.getPort());
            proxyInfo.setNonProxyHosts(proxy.getNonProxyHosts());
            proxyInfo.setUserName(proxy.getUsername());
            proxyInfo.setPassword(proxy.getPassword());
            return proxyInfo;
        }

        AuthenticationInfo getAuthInfo(String serverId) throws SecDispatcherException {
            Server server = RemoteExistsMojo.this.settings.getServer(serverId);
            if (server == null) {
                return null;
            }
            if (RemoteExistsMojo.this.securityDispatcher instanceof DefaultSecDispatcher) {
                ((DefaultSecDispatcher)RemoteExistsMojo.this.securityDispatcher).setConfigurationFile("~/.m2/settings-security.xml");
            }
            AuthenticationInfo authInfo = new AuthenticationInfo();
            authInfo.setUserName(server.getUsername());
            authInfo.setPassword(RemoteExistsMojo.this.securityDispatcher.decrypt(server.getPassword()));
            authInfo.setPassphrase(server.getPassphrase());
            authInfo.setPrivateKey(server.getPrivateKey());
            return authInfo;
        }

        boolean resourceExists(String resourceName) throws Exception {
            return this.wagon.resourceExists(resourceName);
        }

        String getContent(String resourceName) throws Exception {
            byte[] bytes;
            if (this.wagon instanceof StreamingWagon) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ((StreamingWagon)this.wagon).getToStream(resourceName, (OutputStream)baos);
                bytes = baos.toByteArray();
            } else {
                Path tmpFilePath = Files.createTempFile("checksum", null, new FileAttribute[0]);
                File tmpFile = tmpFilePath.toFile();
                tmpFile.deleteOnExit();
                this.wagon.get(resourceName, tmpFile);
                bytes = Files.readAllBytes(tmpFilePath);
            }
            return new String(bytes, StandardCharsets.ISO_8859_1);
        }

        @Override
        public void close() {
            try {
                this.wagon.disconnect();
            }
            catch (ConnectionException e) {
                RemoteExistsMojo.this.getLog().debug((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
            }
        }
    }
}

