/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.exists;

import java.io.Reader;
import java.io.StringReader;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.honton.chas.exists.CheckSum;
import org.honton.chas.exists.GAV;

public abstract class AbstractExistsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(property="exists.project", defaultValue="${project.groupId}:${project.artifactId}:${project.packaging}:${project.version}")
    private String project;
    @Parameter(property="exists.artifact", defaultValue="${project.build.finalName}.${project.packaging}")
    private String artifact;
    @Parameter(property="exists.cmpChecksum", defaultValue="false")
    private boolean cmpChecksum;
    @Parameter(property="exists.skipIfSnapshot", defaultValue="true")
    private boolean skipIfSnapshot;
    @Parameter(property="exists.userProperty", defaultValue="false")
    private boolean userProperty;
    @Parameter(property="exists.failIfExists", defaultValue="false")
    private boolean failIfExists;
    @Parameter(property="exists.failIfNotExists", defaultValue="false")
    private boolean failIfNotExists;
    @Parameter(property="exists.failIfNotMatch", defaultValue="true")
    private boolean failIfNotMatch;
    @Parameter(property="exists.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="exists.requireGoal")
    private String requireGoal;
    @Parameter(property="exists.lastSnapshotTime")
    private String lastSnapshotTime;
    protected GAV gav;

    static Path getPath(String first, String ... more) {
        return FileSystems.getDefault().getPath(first, more);
    }

    protected abstract String getArtifactChecksum(String var1) throws Exception;

    protected abstract String getPropertyName();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping exists execution");
            return;
        }
        if (this.requireGoal != null && !this.session.getGoals().contains(this.requireGoal)) {
            this.getLog().info((CharSequence)(this.requireGoal + " is not present in " + this.session.getGoals() + ", skipping execution"));
            return;
        }
        try {
            String path;
            this.gav = new GAV(this.project, this.mavenProject.getPackaging());
            boolean snapshot = this.isSnapshot();
            if (this.skipIfSnapshot && snapshot) {
                this.getLog().debug((CharSequence)"skipping -SNAPSHOT");
                return;
            }
            if (snapshot) {
                path = this.snapshotPath();
                if (path == null) {
                    this.checkFailConditions(false);
                    return;
                }
            } else {
                path = this.gav.artifactLocation();
            }
            boolean exists = this.checkArtifactExists(path);
            this.checkFailConditions(exists);
            if (!exists) {
                return;
            }
            if (this.cmpChecksum && !this.checksumMatches(path)) {
                return;
            }
            this.setProperty(this.getPropertyName(), "true");
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void setProperty(String propertyName, String value) {
        if (this.userProperty) {
            this.getLog().info((CharSequence)("setting user property " + propertyName + "=" + value));
            this.session.getUserProperties().setProperty(propertyName, value);
        } else {
            this.getLog().info((CharSequence)("setting " + propertyName + "=" + value));
            this.mavenProject.getProperties().setProperty(propertyName, value);
        }
    }

    void setLastSnapshotTime(String updated) {
        if (this.lastSnapshotTime != null) {
            this.setProperty(this.lastSnapshotTime, updated);
        }
    }

    private void checkFailConditions(boolean exists) throws MojoFailureException {
        if (exists) {
            if (this.failIfExists) {
                throw new MojoFailureException("Artifact already exists in repository: " + this.project);
            }
            this.getLog().info((CharSequence)(this.project + " exists"));
        } else {
            if (this.failIfNotExists) {
                throw new MojoFailureException("Artifact does not exist in repository: " + this.project);
            }
            this.getLog().info((CharSequence)(this.project + " does not exist"));
        }
    }

    protected boolean isSnapshot() {
        return this.gav.version.endsWith("-SNAPSHOT");
    }

    private String snapshotPath() {
        try {
            String directory = this.gav.artifactDirectory();
            Metadata metadata = new MetadataXpp3Reader().read((Reader)new StringReader(this.getMavenMetadata(directory)));
            Versioning versioning = metadata.getVersioning();
            for (SnapshotVersion version : versioning.getSnapshotVersions()) {
                if (!this.gav.type.equals(version.getExtension())) continue;
                this.getLog().debug((CharSequence)("version=" + version.getVersion()));
                this.setLastSnapshotTime(version.getUpdated());
                return this.getVersionedPath(version);
            }
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)("Could not fetch/read metadata, assuming no snapshot " + e.getMessage()));
        }
        return null;
    }

    protected abstract String getVersionedPath(SnapshotVersion var1);

    protected abstract String getMavenMetadata(String var1) throws Exception;

    protected abstract boolean checkArtifactExists(String var1) throws Exception;

    private boolean checksumMatches(String path) throws Exception {
        String prior = this.getArtifactChecksum(path);
        String build = this.getBuildChecksum();
        boolean matches = build.equalsIgnoreCase(prior);
        if (!matches) {
            this.getLog().info((CharSequence)(this.project + " checksum does not match"));
            if (this.failIfNotMatch) {
                String msg = "buildChecksum(" + build + ") != priorChecksum(" + prior + ")";
                throw new MojoFailureException(msg);
            }
        }
        return matches;
    }

    private String getBuildChecksum() throws Exception {
        Artifact mavenArtifact = this.mavenProject.getArtifact();
        Path path = "pom".equals(mavenArtifact.getType()) ? AbstractExistsMojo.getPath(this.mavenProject.getBasedir().toString(), "pom.xml") : AbstractExistsMojo.getPath(this.mavenProject.getBuild().getDirectory(), this.artifact);
        if (Files.exists(path, new LinkOption[0])) {
            this.getLog().debug((CharSequence)("Calculating checksum for " + path));
            CheckSum signer = new CheckSum();
            return signer.getChecksum(path);
        }
        throw new MojoFailureException("The project artifact " + path + " has not been created.");
    }
}

