/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.helmrepo.maven.plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.honton.chas.helmrepo.maven.plugin.CommandLineGenerator;
import org.honton.chas.helmrepo.maven.plugin.CommandOptions;
import org.honton.chas.helmrepo.maven.plugin.GlobalReleaseOptions;
import org.honton.chas.helmrepo.maven.plugin.HelmGoal;
import org.honton.chas.helmrepo.maven.plugin.KubernetesInfo;
import org.honton.chas.helmrepo.maven.plugin.ReleaseHelper;
import org.honton.chas.helmrepo.maven.plugin.ReleaseInfo;
import org.honton.chas.helmrepo.maven.plugin.ReleaseState;

public abstract class HelmRelease
extends HelmGoal
implements GlobalReleaseOptions,
CommandOptions {
    @Parameter
    List<ReleaseInfo> releases;
    @Parameter
    String valueYaml;
    @Parameter
    KubernetesInfo kubernetes;
    @Component
    RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    List<RemoteRepository> remoteRepos;
    Path globalValuePath;
    Path targetValuesPath;

    @Override
    protected final void doExecute() throws MojoExecutionException, IOException {
        this.targetValuesPath = Files.createDirectories(Path.of("target", "helm-values"), new FileAttribute[0]);
        if (this.valueYaml != null) {
            this.globalValuePath = this.releaseValues("_.yaml");
            if (this.globalValuePath != null) {
                Files.writeString(this.globalValuePath, (CharSequence)this.valueYaml, new OpenOption[0]);
            }
        }
        for (ReleaseInfo release : this.getIterable(this.getReleasesInRequiredOrder())) {
            CommandLineGenerator generator = new CommandLineGenerator(this).appendGlobalReleaseOptions(this).appendRelease(release, this);
            this.executeHelmCommand(generator.getCommand());
        }
    }

    void pumpLog(InputStream is, Consumer<String> lineConsumer) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            reader.lines().forEach(lineConsumer);
        }
        catch (IOException e) {
            lineConsumer.accept(e.getMessage());
        }
    }

    private void executeHelmCommand(List<String> command) throws MojoExecutionException, IOException {
        try {
            this.getLog().info((CharSequence)String.join((CharSequence)" ", command));
            Process process = new ProcessBuilder(command).start();
            ForkJoinPool pool = ForkJoinPool.commonPool();
            pool.execute(() -> this.pumpLog(process.getInputStream(), arg_0 -> ((Log)this.getLog()).info(arg_0)));
            pool.execute(() -> this.pumpLog(process.getErrorStream(), arg_0 -> ((Log)this.getLog()).error(arg_0)));
            if (process.waitFor() != 0) {
                throw new MojoExecutionException("helm exit value: " + process.exitValue());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    LinkedList<ReleaseInfo> getReleasesInRequiredOrder() {
        List solved;
        long count;
        if (this.releases == null) {
            return new LinkedList<ReleaseInfo>();
        }
        HashMap<String, ReleaseState> releaseToRequirements = new HashMap<String, ReleaseState>();
        this.releases.forEach(release -> {
            this.canonicalize((ReleaseInfo)release);
            ReleaseState requirements = new ReleaseState((ReleaseInfo)release, ReleaseHelper.asSet(release.getRequires()));
            if (releaseToRequirements.put(release.getName(), requirements) != null) {
                throw new IllegalStateException("duplicate definition of " + release.getName());
            }
        });
        releaseToRequirements.forEach((name, value) -> value.getRequires().forEach(require -> {
            ReleaseState requirements = (ReleaseState)releaseToRequirements.get(require);
            if (requirements == null) {
                throw new IllegalArgumentException("Missing definition for require " + require + " on release " + name);
            }
            requirements.addDependent((String)require, (ReleaseState)value);
        }));
        LinkedList<ReleaseInfo> releaseOrder = new LinkedList<ReleaseInfo>();
        while ((count = (solved = releaseToRequirements.values().stream().filter(ReleaseState::isSolved).collect(Collectors.toList())).stream().filter(requirement -> {
            releaseOrder.add(requirement.getRelease());
            releaseToRequirements.remove(requirement.getRelease().getName());
            return requirement.removeRequiresFromDependents();
        }).count()) != 0L) {
        }
        if (!releaseToRequirements.isEmpty()) {
            throw new IllegalArgumentException("Could not determine ordering for releases: " + String.join((CharSequence)", ", releaseToRequirements.keySet()));
        }
        return releaseOrder;
    }

    private void canonicalize(ReleaseInfo release) {
        String chart = release.getChart();
        if (chart == null) {
            throw new IllegalArgumentException("Release must have chart information");
        }
        if (release.getName() == null) {
            release.setName(ReleaseHelper.unversionedName(chart));
        }
        if (ReleaseHelper.isMavenArtifact(chart)) {
            release.setChart(this.localArtifact(chart));
        }
    }

    private String localArtifact(String chart) {
        DefaultArtifact gav = new DefaultArtifact(chart);
        DefaultArtifact chartArtifact = new DefaultArtifact(gav.getGroupId(), gav.getArtifactId(), "tgz", gav.getVersion());
        ArtifactRequest request = new ArtifactRequest((Artifact)chartArtifact, this.remoteRepos, null);
        return this.repoSystem.resolveArtifact(this.repoSession, request).getArtifact().getFile().getAbsolutePath();
    }

    @Generated
    public String getValueYaml() {
        return this.valueYaml;
    }

    @Override
    @Generated
    public KubernetesInfo getKubernetes() {
        return this.kubernetes;
    }

    @Override
    @Generated
    public Path getGlobalValuePath() {
        return this.globalValuePath;
    }
}

