/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.helmrepo.maven.plugin;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.helmrepo.maven.plugin.HelmRelease;
import org.honton.chas.helmrepo.maven.plugin.PortSelector;
import org.honton.chas.helmrepo.maven.plugin.ReleaseInfo;

@Mojo(name="upgrade", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, threadSafe=true)
public class HelmUpgrade
extends HelmRelease {
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    MavenSession session;
    AtomicReference<KubernetesClient> cachedValue = new AtomicReference();

    @Override
    public void addSubCommand(List<String> command) {
        command.add("upgrade");
        command.add("--install");
    }

    @Override
    public String chartReference(ReleaseInfo info) {
        return info.getChart();
    }

    @Override
    public Path releaseValues(String valuesFileName) {
        return this.targetValuesPath.resolve(valuesFileName);
    }

    @Override
    public Iterable<ReleaseInfo> getIterable(LinkedList<ReleaseInfo> inOrder) {
        return inOrder;
    }

    @Override
    protected boolean validateRelease(ReleaseInfo release) {
        boolean errors = super.validateRelease(release);
        List<PortSelector> nodePorts = release.getNodePorts();
        if (nodePorts != null) {
            HashMap nodePortMapping = new HashMap();
            long count = nodePorts.stream().filter(selector -> {
                String propertyName = selector.getPropertyName();
                if (propertyName == null) {
                    this.getLog().error((CharSequence)("Missing propertyName in " + selector));
                    return true;
                }
                if (nodePortMapping.putIfAbsent(propertyName, selector) != null) {
                    this.getLog().error((CharSequence)("Multiple definitions for property " + propertyName));
                    return true;
                }
                if (selector.getServiceName() == null) {
                    this.getLog().error((CharSequence)("Missing service name in " + selector));
                    return true;
                }
                return false;
            }).count();
            errors = count > 0L;
        }
        return errors;
    }

    @Override
    protected void postRelease(ReleaseInfo release) {
        List<PortSelector> portSelectors = release.getNodePorts();
        if (portSelectors != null) {
            Map<String, List<Service>> services = this.getServices(release);
            portSelectors.forEach(selector -> {
                ServicePort servicePort;
                Service foundService = this.findService(release.getName(), services, (PortSelector)selector);
                if (foundService != null && (servicePort = this.findPort(foundService, (PortSelector)selector)) != null) {
                    Integer nodePort = servicePort.getNodePort();
                    if (nodePort == null) {
                        String warning = String.format("Not setting property %s, nodePort not set for portName %s", selector.getPropertyName(), servicePort.getName());
                        this.getLog().warn((CharSequence)warning);
                    } else {
                        this.getLog().info((CharSequence)("Setting " + selector.getPropertyName() + " to " + nodePort));
                        this.session.getUserProperties().setProperty(selector.getPropertyName(), nodePort.toString());
                    }
                }
            });
        }
    }

    private Service findService(String releaseName, Map<String, List<Service>> services, PortSelector selector) {
        List<Service> foundServices = services.get(selector.getServiceName());
        if (foundServices == null || foundServices.isEmpty()) {
            String warning = String.format("Did not set %s; release %s could not find service %s", selector.getPropertyName(), releaseName, selector.getServiceName());
            this.getLog().warn((CharSequence)warning);
            return null;
        }
        Service foundService = foundServices.get(0);
        if (foundServices.size() > 1) {
            String warning = String.format("Release %s found multiple services %s; using namespace %s to set %s", releaseName, selector.getServiceName(), foundService.getMetadata().getNamespace(), selector.getPropertyName());
            this.getLog().warn((CharSequence)warning);
        }
        return foundService;
    }

    private ServicePort findPort(Service foundService, PortSelector selector) {
        List ports = foundService.getSpec().getPorts();
        if (ports == null || ports.isEmpty()) {
            String warning = String.format("Not setting property %s, no ports defined on service %s", selector.getPropertyName(), foundService.getMetadata().getName());
            this.getLog().warn((CharSequence)warning);
            return null;
        }
        String portName = selector.getPortName();
        if (portName != null) {
            Optional<ServicePort> optionalPort = ports.stream().filter(port -> portName.equals(port.getName())).findFirst();
            if (optionalPort.isEmpty()) {
                String warning = String.format("Not setting property %s, no port defined on service %s with portName %s", selector.getPropertyName(), foundService.getMetadata().getName(), portName);
                this.getLog().warn((CharSequence)warning);
                return null;
            }
            return optionalPort.get();
        }
        ServicePort port2 = (ServicePort)ports.get(0);
        if (ports.size() != 1) {
            String warning = String.format("Possible incorrect value for %s, multiple ports defined on service %s and no portName specified; using portName %s", selector.getPropertyName(), foundService.getMetadata().getName(), port2.getName());
            this.getLog().warn((CharSequence)warning);
        }
        return port2;
    }

    private Map<String, List<Service>> getServices(ReleaseInfo release) {
        ServiceList list = this.getServiceList(release.getNamespace());
        HashMap<String, List<Service>> nameToService = new HashMap<String, List<Service>>();
        list.getItems().forEach(service -> nameToService.computeIfAbsent(service.getMetadata().getName(), n -> new ArrayList()).add(service));
        return nameToService;
    }

    private ServiceList getServiceList(String namespace) {
        KubernetesClient client = this.getKubernetesClient();
        MixedOperation services = client.services();
        if (namespace != null) {
            return (ServiceList)((NonNamespaceOperation)services.inNamespace(namespace)).list();
        }
        return (ServiceList)services.list();
    }

    private KubernetesClient getKubernetesClient() {
        KubernetesClient result = this.cachedValue.get();
        if (result == null && !this.cachedValue.compareAndSet(null, result = new KubernetesClientBuilder().build())) {
            return this.cachedValue.get();
        }
        return result;
    }
}

