/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.helmrepo.maven.plugin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.honton.chas.helmrepo.maven.plugin.CommandOptions;
import org.honton.chas.helmrepo.maven.plugin.KubernetesInfo;
import org.honton.chas.helmrepo.maven.plugin.ReleaseInfo;

public class CommandLineGenerator {
    private final List<String> command = new ArrayList<String>();

    public CommandLineGenerator(CommandOptions behavior) {
        this.command.add("helm");
        behavior.addSubCommand(this.command);
    }

    public CommandLineGenerator releaseOptions(ReleaseInfo release, CommandOptions options) throws IOException {
        Path yamlPath;
        String yamlContent;
        this.command.add(release.name);
        String chartName = options.chartReference(release);
        if (chartName != null) {
            this.command.add(chartName);
        }
        if ((yamlContent = release.valueYaml) != null && (yamlPath = options.releaseValues(release.name + ".yaml")) != null) {
            Files.writeString(yamlPath, (CharSequence)yamlContent, new OpenOption[0]);
            this.appendValues(yamlPath);
        }
        options.releaseOptions(release, this.command);
        return this;
    }

    public CommandLineGenerator globalOptions(CommandOptions options, String namespace) {
        Path globalValuesFile;
        this.appendKubernetes(options.getKubernetes());
        Path globalValuePath = options.getGlobalValuePath();
        if (globalValuePath != null) {
            this.appendValues(globalValuePath);
        }
        if ((globalValuesFile = options.getGlobalValuesFile()) != null) {
            this.appendValues(globalValuesFile);
        }
        if (namespace != null) {
            this.command.add("--namespace");
            this.command.add(namespace);
        }
        options.createNamespace(this.command);
        return this;
    }

    private void appendKubernetes(KubernetesInfo kubernetes) {
        String context;
        if (kubernetes != null && (context = kubernetes.getContext()) != null) {
            this.command.add("--kube-context");
            this.command.add(context);
        }
    }

    private void appendValues(Path valuePath) {
        this.command.add("--values");
        this.command.add(valuePath.toString());
    }

    @Generated
    public List<String> getCommand() {
        return this.command;
    }
}

